
/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for Additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License Is distributed on an "AS Is" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */



namespace NPOI.HDF.Model.HDFTypes
{
    using System;
    using NPOI.HDF.Model.HDFTypes.Definitions;
    /**
     * Comment me
     *
     * @author Ryan Ackley
     */

    public class SectionProperties : SEPAbstractType, HDFType
    {
        /*int _index;
        byte _bkc;
        bool _fTitlePage;
        bool _fAutoPgn;
        byte _nfcPgn;
        bool _fUnlocked;
        byte _cnsPgn;
        bool _fPgnRestart;
        bool _fEndNote;
        byte _lnc;
        byte _grpfIhdt;
        short _nLnnMod;
        int _dxaLnn;
        short _dxaPgn;
        short _dyaPgn;
        bool _fLBetween;
        byte _vjc;
        short _dmBinFirst;
        short _dmBinOther;
        short _dmPaperReq;
        short[] _brcTop = new short[2];
        short[] _brcLeft = new short[2];
        short[] _brcBottom = new short[2];
        short[] _brcRight = new short[2];
        bool _fPropMark;
        int _dxtCharSpace;
        int _dyaLinePitch;
        short _clm;
        byte _dmOrientPage;
        byte _iHeadingPgn;
        short _pgnStart;
        short _lnnMin;
        short _wTextFlow;
        short _pgbProp;
        int _xaPage;
        int _yaPage;
        int _dxaLeft;
        int _dxaRight;
        int _dyaTop;
        int _dyaBottom;
        int _dzaGutter;
        int _dyaHdrTop;
        int _dyaHdrBottom;
        short _ccolM1;
        bool _fEvenlySpaced;
        int _dxaColumns;
        int[] _rgdxaColumnWidthSpacing;
        byte _dmOrientFirst;
        byte[] _olstAnn;*/



        public SectionProperties()
        {
            SetBkc((byte)2);
            SetDyaPgn(720);
            SetDxaPgn(720);
            SetFEndNote(true);
            SetFEvenlySpaced(true);
            SetXaPage(12240);
            SetYaPage(15840);
            SetDyaHdrTop(720);
            SetDyaHdrBottom(720);
            SetDmOrientPage((byte)1);
            SetDxaColumns(720);
            SetDyaTop(1440);
            SetDxaLeft(1800);
            SetDyaBottom(1440);
            SetDxaRight(1800);
            SetPgnStart(1);

        }
    }
}