
/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for Additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License Is distributed on an "AS Is" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */



namespace NPOI.HDF.Model.HDFTypes
{
    using System;
    using NPOI.HDF.Model.HDFTypes.Definitions;

    /**
     * Comment me
     *
     * @author Ryan Ackley
     */

    public class ParagraphProperties : PAPAbstractType, ICloneable
    {


        public ParagraphProperties()
        {
            short[] lspd = new short[2];
            SetFWidowControl((byte)1);
            //lspd[0] = 240;
            lspd[1] = 1;
            SetIlvl((byte)9);

            SetLspd(lspd);
            SetBrcBar(new short[2]);
            SetBrcBottom(new short[2]);
            SetBrcLeft(new short[2]);
            SetBrcBetween(new short[2]);
            SetBrcRight(new short[2]);
            SetBrcTop(new short[2]);
            SetPhe(new byte[12]);
            SetAnld(new byte[84]);
            SetDttmPropRMark(new byte[4]);
            SetNumrm(new byte[8]);


        }
        public Object Clone()
        {
            ParagraphProperties clone = (ParagraphProperties)new ParagraphProperties();

            short[] brcBar = new short[2];
            short[] brcBottom = new short[2];
            short[] brcLeft = new short[2];
            short[] brcBetween = new short[2];
            short[] brcRight = new short[2];
            short[] brcTop = new short[2];
            short[] lspd = new short[2];
            byte[] phe = new byte[12];
            byte[] anld = new byte[84];
            byte[] dttmPropRMark = new byte[4];
            byte[] numrm = new byte[8];

            System.Array.Copy(GetBrcBar(), 0, brcBar, 0, 2);
            System.Array.Copy(GetBrcBottom(), 0, brcBottom, 0, 2);
            System.Array.Copy(GetBrcLeft(), 0, brcLeft, 0, 2);
            System.Array.Copy(GetBrcBetween(), 0, brcBetween, 0, 2);
            System.Array.Copy(GetBrcRight(), 0, brcRight, 0, 2);
            System.Array.Copy(GetBrcTop(), 0, brcTop, 0, 2);
            System.Array.Copy(GetLspd(), 0, lspd, 0, 2);
            System.Array.Copy(GetPhe(), 0, phe, 0, 12);
            System.Array.Copy(GetAnld(), 0, anld, 0, 84);
            System.Array.Copy(GetDttmPropRMark(), 0, dttmPropRMark, 0, 4);
            System.Array.Copy(GetNumrm(), 0, numrm, 0, 8);


            clone.SetBrcBar(brcBar);
            clone.SetBrcBottom(brcBottom);
            clone.SetBrcLeft(brcLeft);
            clone.SetBrcBetween(brcBetween);
            clone.SetBrcRight(brcRight);
            clone.SetBrcTop(brcTop);
            clone.SetLspd(lspd);
            clone.SetPhe(phe);
            clone.SetAnld(anld);
            clone.SetDttmPropRMark(dttmPropRMark);
            clone.SetNumrm(numrm);
            return clone;
        }


        internal object clone()
        {
            throw new NotImplementedException();
        }
    }
}