
/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for Additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License Is distributed on an "AS Is" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */



namespace NPOI.HDF.Model.HDFTypes
{
    using System;
    using NPOI.HDF.Model.HDFTypes.Definitions;
    /**
     * Properties for character runs.
     *
     * @author Ryan Ackley
     */

    public class CharacterProperties : CHPAbstractType, ICloneable
    {

        public CharacterProperties()
        {
            SetDttmRMark(new short[2]);
            SetDttmRMarkDel(new short[2]);
            SetXstDispFldRMark(new byte[32]);
            SetBrc(new short[2]); ;
            SetHps(20);
            SetFcPic(-1);
            SetIstd(10);
            SetLidFE(0x0400);
            SetLidDefault(0x0400);
            SetWCharScale(100);
            //setFUsePgsuSettings(-1);
        }
        /**
         * Used to make a deep copy of this object.
         */
        public Object Clone()
        {
            CharacterProperties clone = (CharacterProperties)new CharacterProperties();
            clone.SetBrc(new short[2]);
            System.Array.Copy(GetBrc(), 0, clone.GetBrc(), 0, 2);
            System.Array.Copy(GetDttmRMark(), 0, clone.GetDttmRMark(), 0, 2);
            System.Array.Copy(GetDttmRMarkDel(), 0, clone.GetDttmRMarkDel(), 0, 2);
            System.Array.Copy(GetXstDispFldRMark(), 0, clone.GetXstDispFldRMark(), 0, 32);
            return clone;
        }
    }
}