﻿/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

/* ================================================================
 * Author: Tony Qu 
 * Author's email: tonyqus (at) gmail.com 
 * NPOI HomePage: http://www.codeplex.com/npoi
 * Contributors:
 * 
 * ==============================================================*/

using System;
using System.Text;
using System.IO;
using NPOI.HSSF.UserModel;
using NPOI.HPSF;
using NPOI.POIFS.FileSystem;
using NPOI.SS.UserModel;

namespace SetAlignmentInXls
{
    class Program
    {
        static void Main(string[] args)
        {
            InitializeWorkbook();

            Sheet sheet1 = hssfworkbook.CreateSheet("Sheet1");

            //set the column width respectively
            sheet1.SetColumnWidth(0, 3000);
            sheet1.SetColumnWidth(1, 3000);
            sheet1.SetColumnWidth(2, 3000);

            for (int i = 1; i <= 10; i++)
            {
                //create the row
                Row row = sheet1.CreateRow(i);
                //set height of the row
                row.HeightInPoints = 100;

                //create the first cell
                row.CreateCell(0).SetCellValue("Left");
                CellStyle styleLeft=hssfworkbook.CreateCellStyle();
                styleLeft.Alignment = HorizontalAlignment.LEFT;
                styleLeft.VerticalAlignment = VerticalAlignment.TOP;
                row.GetCell(0).CellStyle = styleLeft;
                //set indention for the text in the cell
                styleLeft.Indention = 3;

                //create the second cell
                row.CreateCell(1).SetCellValue("Center Hello World Hello WorldHello WorldHello WorldHello WorldHello World");
                CellStyle styleMiddle = hssfworkbook.CreateCellStyle();
                styleMiddle.Alignment = HorizontalAlignment.CENTER;
                styleMiddle.VerticalAlignment = VerticalAlignment.CENTER;
                row.GetCell(1).CellStyle = styleMiddle;
                //wrap the text in the cell
                styleMiddle.WrapText = true;
                

                //create the third cell
                row.CreateCell(2).SetCellValue("Right");
                CellStyle styleRight = hssfworkbook.CreateCellStyle();
                styleRight.Alignment = HorizontalAlignment.JUSTIFY;
                styleRight.VerticalAlignment = VerticalAlignment.BOTTOM;
                row.GetCell(2).CellStyle = styleRight;

            }

            WriteToFile();
        }

        static HSSFWorkbook hssfworkbook;

        static void WriteToFile()
        {
            //Write the stream data of workbook to the root directory
            FileStream file = new FileStream(@"test.xls", FileMode.Create);
            hssfworkbook.Write(file);
            file.Close();
        }

        static void InitializeWorkbook()
        {
            hssfworkbook = new HSSFWorkbook();

            ////create a entry of DocumentSummaryInformation
            DocumentSummaryInformation dsi = PropertySetFactory.CreateDocumentSummaryInformation();
            dsi.Company = "NPOI Team";
            hssfworkbook.DocumentSummaryInformation = dsi;

            ////create a entry of SummaryInformation
            SummaryInformation si = PropertySetFactory.CreateSummaryInformation();
            si.Subject = "NPOI SDK Example";
            hssfworkbook.SummaryInformation = si;
        }
    }
}
