﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/Site.Master" AutoEventWireup="true" CodeBehind="Index.aspx.cs" Inherits="SVN.Net.Views.Home.Index" %>
<%@ Import Namespace="SVN.Net.Misc" %>
<asp:Content ID="indexContent" ContentPlaceHolderID="MainContent" runat="server">
    <h2><%= Html.Encode(ViewData["Message"]) %></h2>
    <!-- Repo URL and authentication information -->
    <form action="/Home/Navigate" method="post">
        <table width="100%">
            <tr>
                <td width="25%">Repo Path:</td>
                <td width="75%"><%= Html.TextBox("repo", ViewData["repo"] ?? string.Empty) %></td>
            </tr>
            <tr>
                <td width="25%">Username:</td>
                <td width="75%"><%= Html.TextBox("uid", ViewData["uid"] ?? string.Empty)%> &nbsp <i>Blank if the repo doesn't need authentication information.</i></td>
            </tr>
            <tr>
                <td width="25%">Password:</td>
                <td width="75%"><%= Html.Password("pwd", ViewData["pwd"] ?? string.Empty)%> &nbsp <i>Blank if the repo doesn't need authentication information.</i></td>
            </tr>
            <tr>
                <td colspan="2"><%= Html.SubmitButton("Navigate", "Login") %></td>
            </tr>
        </table>
    </form>
    <!-- List for the repo. -->
    <% if (ViewData.Model != null)
       { %>
    <table width="100%">
        <tr id="commands">
            <td></td>
            <td width="5%"></td>
            <td width="5%"></td>
            <td width="10%"></td>
            <td width="20%" align="right">
                <%= Html.ActionImageLink("../../Content/Images/export.png", "Export", "Export", "Home", new { repo = ViewData["repo"] })%>
            </td>
            <td width="5%" align="right">
                <%= Html.ActionImageLink("../../Content/Images/newfolder.png", "Create folder", "CreateFolder", "Editor", new { repo = ViewData["repo"] })%>
            </td>
            <td width="5%" align="right">
                <%= Html.ActionImageLink("../../Content/Images/newfile.png", "Create file", "CreateFile", "Editor", new { repo = ViewData["repo"] })%>
            </td>
        </tr>
        <tr id="header" style="background-color: #5c87b2">
            <td>Name</td>
            <td width="5%">Size</td>
            <td width="5%">Rev</td>
            <td width="10%">Author</td>
            <td width="20%">Date</td>
            <td width="5%"></td>
            <td width="5%"></td>
        </tr>
        <tr>
            <td>
                <img src="../../Content/Images/folderup.png" alt="Move Up" />
                <%= 
                    Html.ActionLink("..", "Navigate", "Home", new { repo = global_asax.GetPath(ViewData["repo"].ToString()) }, null)
                %>
            </td>
            <td width="5%"></td>
            <td width="5%"></td>
            <td width="10%"></td>
            <td width="20%"></td>
            <td width="5%"></td>
            <td width="5%"></td>
        </tr>
        <% 
           string kind = string.Empty;
           string name = string.Empty;
           long size = 0;
           long ver = 0;
           string author = string.Empty;
           DateTime date = DateTime.Now;
           System.Xml.XmlNode commit = null;
           foreach (System.Xml.XmlNode entry in ViewData.Model.SelectNodes(@"//lists/list/entry"))
           {
               kind = entry.Attributes["kind"].Value;
               name = entry.SelectSingleNode("name").InnerText;
               if (entry.SelectSingleNode("size") != null)
                   long.TryParse(entry.SelectSingleNode("size").InnerText, out size);
               commit = entry.SelectSingleNode("commit");
               long.TryParse(commit.Attributes["revision"].Value, out ver);
               author = commit.SelectSingleNode("author").InnerText;
               DateTime.TryParse(commit.SelectSingleNode("date").InnerText, out date);
        %>
        <tr>
            <td>
            <%
                if (string.Compare(kind, "dir", true) == 0)
                {
            %>
                <img src="../../Content/Images/folder.png" alt="Folder" />
                <% = Html.ActionLink(Html.Encode(name), "Navigate", "Home", new { repo = ViewData["repo"].ToString() + "/" + name }, null) %>
            <% }
                else
                { %>
                <img src="../../Content/Images/file.png" alt="File" />
                <% = Html.ActionLink(Html.Encode(name), "Edit", "Editor", new { repo = ViewData["repo"].ToString() + "/" + name }, null)%>
            <% }
            %>
            </td>
            <td width="5%"><%= Html.Encode(size.ToString())%></td>
            <td width="5%"><%= Html.Encode(ver.ToString())%></td>
            <td width="10%"><%= Html.Encode(author)%></td>
            <td width="10%"><%= Html.Encode(date.ToString())%></td>
            <td width="10%">
                <%= Html.ActionImageLink("../../Content/Images/rename.png", "Rename", "Rename", "Editor", 
                        new { repo = string.Format("{0}/{1}", ViewData["repo"], name) }) %>
            </td>
            <td width="10%">
                <%= Html.ActionImageLink("../../Content/Images/delete.png", "Delete", "Delete", "Editor", 
                        new { repo = string.Format("{0}/{1}", ViewData["repo"], name) }, 
                        new { onclick = "return(confirm('Do you want to delete this file/folder?'))" }) %>
            </td>
        </tr>
                <%
        }
       }
        %>
    </table>
</asp:Content>
