
/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for Additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License Is distributed on an "AS Is" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */



namespace NPOI.HDF.Model.HDFTypes
{
    using NPOI.HDF.Model.HDFTypes.Definitions;
    using NPOI.Util;
    /**
     * Comment me
     *
     * @author Ryan Ackley
     */

    public class TableCellDescriptor : TCAbstractType, HDFType
    {

        /*bool _fFirstMerged;
        bool _fMerged;
        bool _fVertical;
        bool _fBackward;
        bool _fRotateFont;
        bool _fVertMerge;
        bool _fVertRestart;
        short _vertAlign;
        short[] _brcTop = new short[2];
        short[] _brcLeft = new short[2];
        short[] _brcBottom = new short[2];
        short[] _brcRight = new short [2];*/

        public TableCellDescriptor()
        {
        }
        internal static TableCellDescriptor ConvertBytesToTC(byte[] array, int offset)
        {
            TableCellDescriptor tc = new TableCellDescriptor();
            int rgf = LittleEndian.GetShort(array, offset);
            tc.SetFFirstMerged((rgf & 0x0001) > 0);
            tc.SetFMerged((rgf & 0x0002) > 0);
            tc.SetFVertical((rgf & 0x0004) > 0);
            tc.SetFBackward((rgf & 0x0008) > 0);
            tc.SetFRotateFont((rgf & 0x0010) > 0);
            tc.SetFVertMerge((rgf & 0x0020) > 0);
            tc.SetFVertRestart((rgf & 0x0040) > 0);
            tc.SetVertAlign((byte)((rgf & 0x0180) >> 7));

            short[] brcTop = new short[2];
            short[] brcLeft = new short[2];
            short[] brcBottom = new short[2];
            short[] brcRight = new short[2];

            brcTop[0] = LittleEndian.GetShort(array, offset + 4);
            brcTop[1] = LittleEndian.GetShort(array, offset + 6);

            brcLeft[0] = LittleEndian.GetShort(array, offset + 8);
            brcLeft[1] = LittleEndian.GetShort(array, offset + 10);

            brcBottom[0] = LittleEndian.GetShort(array, offset + 12);
            brcBottom[1] = LittleEndian.GetShort(array, offset + 14);

            brcRight[0] = LittleEndian.GetShort(array, offset + 16);
            brcRight[1] = LittleEndian.GetShort(array, offset + 18);

            return tc;
        }

    }
}