
/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for Additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License Is distributed on an "AS Is" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */


namespace NPOI.HDF.Model.HDFTypes
{

    using System;
    using System.Text;
    using NPOI.Util;
    /**
     * Comment me
     *
     * @author Ryan Ackley
     */

    public class FontTable : HDFType
    {
        String[] fontNames;

        public FontTable(byte[] fontTable)
        {
            int size = LittleEndian.GetShort(fontTable, 0);
            fontNames = new String[size];

            int currentIndex = 4;
            for (int x = 0; x < size; x++)
            {
                byte ffnLength = fontTable[currentIndex];

                int nameOffset = currentIndex + 40;
                StringBuilder nameBuf = new StringBuilder();
                //char ch = Utils.GetUnicodeCharacter(fontTable, nameOffset);
                char ch = (char)LittleEndian.GetShort(fontTable, nameOffset);
                while (ch != '\0')
                {
                    nameBuf.Append(ch);
                    nameOffset += 2;
                    ch = (char)LittleEndian.GetShort(fontTable, nameOffset);
                }
                fontNames[x] = nameBuf.ToString();
                currentIndex += ffnLength + 1;
            }

        }
        public String GetFont(int index)
        {
            return fontNames[index];
        }
    }
}