
/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for Additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License Is distributed on an "AS Is" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */



namespace NPOI.HDF.Model.HDFTypes.Definitions
{


    using System;
    using System.Text;
    using NPOI.Util;
    using NPOI.HDF.Model.HDFTypes;

    /**
     * File information Block.
     * NOTE: This source Is automatically generated please do not modify this file.  Either subclass or
     *       Remove the record in src/records/definitions.

     * @author Andrew C. Oliver
     */
    public abstract class FIBAbstractType
        : HDFType
    {

        private int field_1_wIdent;
        private int field_2_nFib;
        private int field_3_nProduct;
        private int field_4_lid;
        private int field_5_pnNext;
        private short field_6_options;
        private static BitField fDot = BitFieldFactory.GetInstance(0x0001);
        private static BitField fGlsy = BitFieldFactory.GetInstance(0x0002);
        private static BitField fComplex = BitFieldFactory.GetInstance(0x0004);
        private static BitField fHasPic = BitFieldFactory.GetInstance(0x0008);
        private static BitField cQuickSaves = BitFieldFactory.GetInstance(0x00F0);
        private static BitField fEncrypted = BitFieldFactory.GetInstance(0x0100);
        private static BitField fWhichTblStm = BitFieldFactory.GetInstance(0x0200);
        private static BitField fReadOnlyRecommended = BitFieldFactory.GetInstance(0x0400);
        private static BitField fWriteReservation = BitFieldFactory.GetInstance(0x0800);
        private static BitField fExtChar = BitFieldFactory.GetInstance(0x1000);
        private static BitField fLoadOverride = BitFieldFactory.GetInstance(0x2000);
        private static BitField fFarEast = BitFieldFactory.GetInstance(0x4000);
        private static BitField fCrypto = BitFieldFactory.GetInstance(0x8000);
        private int field_7_nFibBack;
        private int field_8_lKey;
        private int field_9_envr;
        private short field_10_history;
        private static BitField fMac = BitFieldFactory.GetInstance(0x0001);
        private static BitField fEmptySpecial = BitFieldFactory.GetInstance(0x0002);
        private static BitField fLoadOverridePage = BitFieldFactory.GetInstance(0x0004);
        private static BitField fFutureSavedUndo = BitFieldFactory.GetInstance(0x0008);
        private static BitField fWord97Saved = BitFieldFactory.GetInstance(0x0010);
        private static BitField fSpare0 = BitFieldFactory.GetInstance(0x00FE);
        private int field_11_chs;
        private int field_12_chsTables;
        private int field_13_fcMin;
        private int field_14_fcMac;
        private int field_15_csw;
        private int field_16_wMagicCreated;
        private int field_17_wMagicRevised;
        private int field_18_wMagicCreatedPrivate;
        private int field_19_wMagicRevisedPrivate;
        private int field_20_pnFbpChpFirst_W6;
        private int field_21_pnChpFirst_W6;
        private int field_22_cpnBteChp_W6;
        private int field_23_pnFbpPapFirst_W6;
        private int field_24_pnPapFirst_W6;
        private int field_25_cpnBtePap_W6;
        private int field_26_pnFbpLvcFirst_W6;
        private int field_27_pnLvcFirst_W6;
        private int field_28_cpnBteLvc_W6;
        private int field_29_lidFE;
        private int field_30_clw;
        private int field_31_cbMac;
        private int field_32_lProductCreated;
        private int field_33_lProductRevised;
        private int field_34_ccpText;
        private int field_35_ccpFtn;
        private int field_36_ccpHdd;
        private int field_37_ccpMcr;
        private int field_38_ccpAtn;
        private int field_39_ccpEdn;
        private int field_40_ccpTxbx;
        private int field_41_ccpHdrTxbx;
        private int field_42_pnFbpChpFirst;
        private int field_43_pnChpFirst;
        private int field_44_cpnBteChp;
        private int field_45_pnFbpPapFirst;
        private int field_46_pnPapFirst;
        private int field_47_cpnBtePap;
        private int field_48_pnFbpLvcFirst;
        private int field_49_pnLvcFirst;
        private int field_50_cpnBteLvc;
        private int field_51_fcIslandFirst;
        private int field_52_fcIslandLim;
        private int field_53_cfclcb;
        private int field_54_fcStshfOrig;
        private int field_55_lcbStshfOrig;
        private int field_56_fcStshf;
        private int field_57_lcbStshf;
        private int field_58_fcPlcffndRef;
        private int field_59_lcbPlcffndRef;
        private int field_60_fcPlcffndTxt;
        private int field_61_lcbPlcffndTxt;
        private int field_62_fcPlcfandRef;
        private int field_63_lcbPlcfandRef;
        private int field_64_fcPlcfandTxt;
        private int field_65_lcbPlcfandTxt;
        private int field_66_fcPlcfsed;
        private int field_67_lcbPlcfsed;
        private int field_68_fcPlcpad;
        private int field_69_lcbPlcpad;
        private int field_70_fcPlcfphe;
        private int field_71_lcbPlcfphe;
        private int field_72_fcSttbfglsy;
        private int field_73_lcbSttbfglsy;
        private int field_74_fcPlcfglsy;
        private int field_75_lcbPlcfglsy;
        private int field_76_fcPlcfhdd;
        private int field_77_lcbPlcfhdd;
        private int field_78_fcPlcfbteChpx;
        private int field_79_lcbPlcfbteChpx;
        private int field_80_fcPlcfbtePapx;
        private int field_81_lcbPlcfbtePapx;
        private int field_82_fcPlcfsea;
        private int field_83_lcbPlcfsea;
        private int field_84_fcSttbfffn;
        private int field_85_lcbSttbfffn;
        private int field_86_fcPlcffldMom;
        private int field_87_lcbPlcffldMom;
        private int field_88_fcPlcffldHdr;
        private int field_89_lcbPlcffldHdr;
        private int field_90_fcPlcffldFtn;
        private int field_91_lcbPlcffldFtn;
        private int field_92_fcPlcffldAtn;
        private int field_93_lcbPlcffldAtn;
        private int field_94_fcPlcffldMcr;
        private int field_95_lcbPlcffldMcr;
        private int field_96_fcSttbfbkmk;
        private int field_97_lcbSttbfbkmk;
        private int field_98_fcPlcfbkf;
        private int field_99_lcbPlcfbkf;
        private int field_100_fcPlcfbkl;
        private int field_101_lcbPlcfbkl;
        private int field_102_fcCmds;
        private int field_103_lcbCmds;
        private int field_104_fcPlcmcr;
        private int field_105_lcbPlcmcr;
        private int field_106_fcSttbfmcr;
        private int field_107_lcbSttbfmcr;
        private int field_108_fcPrDrvr;
        private int field_109_lcbPrDrvr;
        private int field_110_fcPrEnvPort;
        private int field_111_lcbPrEnvPort;
        private int field_112_fcPrEnvLand;
        private int field_113_lcbPrEnvLand;
        private int field_114_fcWss;
        private int field_115_lcbWss;
        private int field_116_fcDop;
        private int field_117_lcbDop;
        private int field_118_fcSttbfAssoc;
        private int field_119_lcbSttbfAssoc;
        private int field_120_fcClx;
        private int field_121_lcbClx;
        private int field_122_fcPlcfpgdFtn;
        private int field_123_lcbPlcfpgdFtn;
        private int field_124_fcAutosaveSource;
        private int field_125_lcbAutosaveSource;
        private int field_126_fcGrpXstAtnOwners;
        private int field_127_lcbGrpXstAtnOwners;
        private int field_128_fcSttbfAtnbkmk;
        private int field_129_lcbSttbfAtnbkmk;
        private int field_130_fcPlcdoaMom;
        private int field_131_lcbPlcdoaMom;
        private int field_132_fcPlcdoaHdr;
        private int field_133_lcbPlcdoaHdr;
        private int field_134_fcPlcspaMom;
        private int field_135_lcbPlcspaMom;
        private int field_136_fcPlcspaHdr;
        private int field_137_lcbPlcspaHdr;
        private int field_138_fcPlcfAtnbkf;
        private int field_139_lcbPlcfAtnbkf;
        private int field_140_fcPlcfAtnbkl;
        private int field_141_lcbPlcfAtnbkl;
        private int field_142_fcPms;
        private int field_143_lcbPms;
        private int field_144_fcFormFldSttbs;
        private int field_145_lcbFormFldSttbs;
        private int field_146_fcPlcfendRef;
        private int field_147_lcbPlcfendRef;
        private int field_148_fcPlcfendTxt;
        private int field_149_lcbPlcfendTxt;
        private int field_150_fcPlcffldEdn;
        private int field_151_lcbPlcffldEdn;
        private int field_152_fcPlcfpgdEdn;
        private int field_153_lcbPlcfpgdEdn;
        private int field_154_fcDggInfo;
        private int field_155_lcbDggInfo;
        private int field_156_fcSttbfRMark;
        private int field_157_lcbSttbfRMark;
        private int field_158_fcSttbCaption;
        private int field_159_lcbSttbCaption;
        private int field_160_fcSttbAutoCaption;
        private int field_161_lcbSttbAutoCaption;
        private int field_162_fcPlcfwkb;
        private int field_163_lcbPlcfwkb;
        private int field_164_fcPlcfspl;
        private int field_165_lcbPlcfspl;
        private int field_166_fcPlcftxbxTxt;
        private int field_167_lcbPlcftxbxTxt;
        private int field_168_fcPlcffldTxbx;
        private int field_169_lcbPlcffldTxbx;
        private int field_170_fcPlcfhdrtxbxTxt;
        private int field_171_lcbPlcfhdrtxbxTxt;
        private int field_172_fcPlcffldHdrTxbx;
        private int field_173_lcbPlcffldHdrTxbx;
        private int field_174_fcStwUser;
        private int field_175_lcbStwUser;
        private int field_176_fcSttbttmbd;
        private int field_177_cbSttbttmbd;
        private int field_178_fcUnused;
        private int field_179_lcbUnused;
        private int field_180_fcPgdMother;
        private int field_181_lcbPgdMother;
        private int field_182_fcBkdMother;
        private int field_183_lcbBkdMother;
        private int field_184_fcPgdFtn;
        private int field_185_lcbPgdFtn;
        private int field_186_fcBkdFtn;
        private int field_187_lcbBkdFtn;
        private int field_188_fcPgdEdn;
        private int field_189_lcbPgdEdn;
        private int field_190_fcBkdEdn;
        private int field_191_lcbBkdEdn;
        private int field_192_fcSttbfIntlFld;
        private int field_193_lcbSttbfIntlFld;
        private int field_194_fcRouteSlip;
        private int field_195_lcbRouteSlip;
        private int field_196_fcSttbSavedBy;
        private int field_197_lcbSttbSavedBy;
        private int field_198_fcSttbFnm;
        private int field_199_lcbSttbFnm;
        private int field_200_fcPlcfLst;
        private int field_201_lcbPlcfLst;
        private int field_202_fcPlfLfo;
        private int field_203_lcbPlfLfo;
        private int field_204_fcPlcftxbxBkd;
        private int field_205_lcbPlcftxbxBkd;
        private int field_206_fcPlcftxbxHdrBkd;
        private int field_207_lcbPlcftxbxHdrBkd;
        private int field_208_fcDocUndo;
        private int field_209_lcbDocUndo;
        private int field_210_fcRgbuse;
        private int field_211_lcbRgbuse;
        private int field_212_fcUsp;
        private int field_213_lcbUsp;
        private int field_214_fcUskf;
        private int field_215_lcbUskf;
        private int field_216_fcPlcupcRgbuse;
        private int field_217_lcbPlcupcRgbuse;
        private int field_218_fcPlcupcUsp;
        private int field_219_lcbPlcupcUsp;
        private int field_220_fcSttbGlsyStyle;
        private int field_221_lcbSttbGlsyStyle;
        private int field_222_fcPlgosl;
        private int field_223_lcbPlgosl;
        private int field_224_fcPlcocx;
        private int field_225_lcbPlcocx;
        private int field_226_fcPlcfbteLvc;
        private int field_227_lcbPlcfbteLvc;
        private int field_228_dwLowDateTime;
        private int field_229_dwHighDateTime;
        private int field_230_fcPlcflvc;
        private int field_231_lcbPlcflvc;
        private int field_232_fcPlcasumy;
        private int field_233_lcbPlcasumy;
        private int field_234_fcPlcfgram;
        private int field_235_lcbPlcfgram;
        private int field_236_fcSttbListNames;
        private int field_237_lcbSttbListNames;
        private int field_238_fcSttbfUssr;
        private int field_239_lcbSttbfUssr;


        public FIBAbstractType()
        {

        }

        protected void fillFields(byte[] data, short Size, int offset)
        {
            field_1_wIdent = LittleEndian.GetShort(data, 0x0 + offset);
            field_2_nFib = LittleEndian.GetShort(data, 0x2 + offset);
            field_3_nProduct = LittleEndian.GetShort(data, 0x4 + offset);
            field_4_lid = LittleEndian.GetShort(data, 0x6 + offset);
            field_5_pnNext = LittleEndian.GetShort(data, 0x8 + offset);
            field_6_options = LittleEndian.GetShort(data, 0xa + offset);
            field_7_nFibBack = LittleEndian.GetShort(data, 0xc + offset);
            field_8_lKey = LittleEndian.GetShort(data, 0xe + offset);
            field_9_envr = LittleEndian.GetShort(data, 0x10 + offset);
            field_10_history = LittleEndian.GetShort(data, 0x12 + offset);
            field_11_chs = LittleEndian.GetShort(data, 0x14 + offset);
            field_12_chsTables = LittleEndian.GetShort(data, 0x16 + offset);
            field_13_fcMin = LittleEndian.GetInt(data, 0x18 + offset);
            field_14_fcMac = LittleEndian.GetInt(data, 0x1c + offset);
            field_15_csw = LittleEndian.GetShort(data, 0x20 + offset);
            field_16_wMagicCreated = LittleEndian.GetShort(data, 0x22 + offset);
            field_17_wMagicRevised = LittleEndian.GetShort(data, 0x24 + offset);
            field_18_wMagicCreatedPrivate = LittleEndian.GetShort(data, 0x26 + offset);
            field_19_wMagicRevisedPrivate = LittleEndian.GetShort(data, 0x28 + offset);
            field_20_pnFbpChpFirst_W6 = LittleEndian.GetShort(data, 0x2a + offset);
            field_21_pnChpFirst_W6 = LittleEndian.GetShort(data, 0x2c + offset);
            field_22_cpnBteChp_W6 = LittleEndian.GetShort(data, 0x2e + offset);
            field_23_pnFbpPapFirst_W6 = LittleEndian.GetShort(data, 0x30 + offset);
            field_24_pnPapFirst_W6 = LittleEndian.GetShort(data, 0x32 + offset);
            field_25_cpnBtePap_W6 = LittleEndian.GetShort(data, 0x34 + offset);
            field_26_pnFbpLvcFirst_W6 = LittleEndian.GetShort(data, 0x36 + offset);
            field_27_pnLvcFirst_W6 = LittleEndian.GetShort(data, 0x38 + offset);
            field_28_cpnBteLvc_W6 = LittleEndian.GetShort(data, 0x3a + offset);
            field_29_lidFE = LittleEndian.GetShort(data, 0x3c + offset);
            field_30_clw = LittleEndian.GetShort(data, 0x3e + offset);
            field_31_cbMac = LittleEndian.GetInt(data, 0x40 + offset);
            field_32_lProductCreated = LittleEndian.GetInt(data, 0x44 + offset);
            field_33_lProductRevised = LittleEndian.GetInt(data, 0x48 + offset);
            field_34_ccpText = LittleEndian.GetInt(data, 0x4c + offset);
            field_35_ccpFtn = LittleEndian.GetInt(data, 0x50 + offset);
            field_36_ccpHdd = LittleEndian.GetInt(data, 0x54 + offset);
            field_37_ccpMcr = LittleEndian.GetInt(data, 0x58 + offset);
            field_38_ccpAtn = LittleEndian.GetInt(data, 0x5c + offset);
            field_39_ccpEdn = LittleEndian.GetInt(data, 0x60 + offset);
            field_40_ccpTxbx = LittleEndian.GetInt(data, 0x64 + offset);
            field_41_ccpHdrTxbx = LittleEndian.GetInt(data, 0x68 + offset);
            field_42_pnFbpChpFirst = LittleEndian.GetInt(data, 0x6c + offset);
            field_43_pnChpFirst = LittleEndian.GetInt(data, 0x70 + offset);
            field_44_cpnBteChp = LittleEndian.GetInt(data, 0x74 + offset);
            field_45_pnFbpPapFirst = LittleEndian.GetInt(data, 0x78 + offset);
            field_46_pnPapFirst = LittleEndian.GetInt(data, 0x7c + offset);
            field_47_cpnBtePap = LittleEndian.GetInt(data, 0x80 + offset);
            field_48_pnFbpLvcFirst = LittleEndian.GetInt(data, 0x84 + offset);
            field_49_pnLvcFirst = LittleEndian.GetInt(data, 0x88 + offset);
            field_50_cpnBteLvc = LittleEndian.GetInt(data, 0x8c + offset);
            field_51_fcIslandFirst = LittleEndian.GetInt(data, 0x90 + offset);
            field_52_fcIslandLim = LittleEndian.GetInt(data, 0x94 + offset);
            field_53_cfclcb = LittleEndian.GetShort(data, 0x98 + offset);
            field_54_fcStshfOrig = LittleEndian.GetInt(data, 0x9a + offset);
            field_55_lcbStshfOrig = LittleEndian.GetInt(data, 0x9e + offset);
            field_56_fcStshf = LittleEndian.GetInt(data, 0xa2 + offset);
            field_57_lcbStshf = LittleEndian.GetInt(data, 0xa6 + offset);
            field_58_fcPlcffndRef = LittleEndian.GetInt(data, 0xaa + offset);
            field_59_lcbPlcffndRef = LittleEndian.GetInt(data, 0xae + offset);
            field_60_fcPlcffndTxt = LittleEndian.GetInt(data, 0xb2 + offset);
            field_61_lcbPlcffndTxt = LittleEndian.GetInt(data, 0xb6 + offset);
            field_62_fcPlcfandRef = LittleEndian.GetInt(data, 0xba + offset);
            field_63_lcbPlcfandRef = LittleEndian.GetInt(data, 0xbe + offset);
            field_64_fcPlcfandTxt = LittleEndian.GetInt(data, 0xc2 + offset);
            field_65_lcbPlcfandTxt = LittleEndian.GetInt(data, 0xc6 + offset);
            field_66_fcPlcfsed = LittleEndian.GetInt(data, 0xca + offset);
            field_67_lcbPlcfsed = LittleEndian.GetInt(data, 0xce + offset);
            field_68_fcPlcpad = LittleEndian.GetInt(data, 0xd2 + offset);
            field_69_lcbPlcpad = LittleEndian.GetInt(data, 0xd6 + offset);
            field_70_fcPlcfphe = LittleEndian.GetInt(data, 0xda + offset);
            field_71_lcbPlcfphe = LittleEndian.GetInt(data, 0xde + offset);
            field_72_fcSttbfglsy = LittleEndian.GetInt(data, 0xe2 + offset);
            field_73_lcbSttbfglsy = LittleEndian.GetInt(data, 0xe6 + offset);
            field_74_fcPlcfglsy = LittleEndian.GetInt(data, 0xea + offset);
            field_75_lcbPlcfglsy = LittleEndian.GetInt(data, 0xee + offset);
            field_76_fcPlcfhdd = LittleEndian.GetInt(data, 0xf2 + offset);
            field_77_lcbPlcfhdd = LittleEndian.GetInt(data, 0xf6 + offset);
            field_78_fcPlcfbteChpx = LittleEndian.GetInt(data, 0xfa + offset);
            field_79_lcbPlcfbteChpx = LittleEndian.GetInt(data, 0xfe + offset);
            field_80_fcPlcfbtePapx = LittleEndian.GetInt(data, 0x102 + offset);
            field_81_lcbPlcfbtePapx = LittleEndian.GetInt(data, 0x106 + offset);
            field_82_fcPlcfsea = LittleEndian.GetInt(data, 0x10a + offset);
            field_83_lcbPlcfsea = LittleEndian.GetInt(data, 0x10e + offset);
            field_84_fcSttbfffn = LittleEndian.GetInt(data, 0x112 + offset);
            field_85_lcbSttbfffn = LittleEndian.GetInt(data, 0x116 + offset);
            field_86_fcPlcffldMom = LittleEndian.GetInt(data, 0x11a + offset);
            field_87_lcbPlcffldMom = LittleEndian.GetInt(data, 0x11e + offset);
            field_88_fcPlcffldHdr = LittleEndian.GetInt(data, 0x122 + offset);
            field_89_lcbPlcffldHdr = LittleEndian.GetInt(data, 0x126 + offset);
            field_90_fcPlcffldFtn = LittleEndian.GetInt(data, 0x12a + offset);
            field_91_lcbPlcffldFtn = LittleEndian.GetInt(data, 0x12e + offset);
            field_92_fcPlcffldAtn = LittleEndian.GetInt(data, 0x132 + offset);
            field_93_lcbPlcffldAtn = LittleEndian.GetInt(data, 0x136 + offset);
            field_94_fcPlcffldMcr = LittleEndian.GetInt(data, 0x13a + offset);
            field_95_lcbPlcffldMcr = LittleEndian.GetInt(data, 0x13e + offset);
            field_96_fcSttbfbkmk = LittleEndian.GetInt(data, 0x142 + offset);
            field_97_lcbSttbfbkmk = LittleEndian.GetInt(data, 0x146 + offset);
            field_98_fcPlcfbkf = LittleEndian.GetInt(data, 0x14a + offset);
            field_99_lcbPlcfbkf = LittleEndian.GetInt(data, 0x14e + offset);
            field_100_fcPlcfbkl = LittleEndian.GetInt(data, 0x152 + offset);
            field_101_lcbPlcfbkl = LittleEndian.GetInt(data, 0x156 + offset);
            field_102_fcCmds = LittleEndian.GetInt(data, 0x15a + offset);
            field_103_lcbCmds = LittleEndian.GetInt(data, 0x15e + offset);
            field_104_fcPlcmcr = LittleEndian.GetInt(data, 0x162 + offset);
            field_105_lcbPlcmcr = LittleEndian.GetInt(data, 0x166 + offset);
            field_106_fcSttbfmcr = LittleEndian.GetInt(data, 0x16a + offset);
            field_107_lcbSttbfmcr = LittleEndian.GetInt(data, 0x16e + offset);
            field_108_fcPrDrvr = LittleEndian.GetInt(data, 0x172 + offset);
            field_109_lcbPrDrvr = LittleEndian.GetInt(data, 0x176 + offset);
            field_110_fcPrEnvPort = LittleEndian.GetInt(data, 0x17a + offset);
            field_111_lcbPrEnvPort = LittleEndian.GetInt(data, 0x17e + offset);
            field_112_fcPrEnvLand = LittleEndian.GetInt(data, 0x182 + offset);
            field_113_lcbPrEnvLand = LittleEndian.GetInt(data, 0x186 + offset);
            field_114_fcWss = LittleEndian.GetInt(data, 0x18a + offset);
            field_115_lcbWss = LittleEndian.GetInt(data, 0x18e + offset);
            field_116_fcDop = LittleEndian.GetInt(data, 0x192 + offset);
            field_117_lcbDop = LittleEndian.GetInt(data, 0x196 + offset);
            field_118_fcSttbfAssoc = LittleEndian.GetInt(data, 0x19a + offset);
            field_119_lcbSttbfAssoc = LittleEndian.GetInt(data, 0x19e + offset);
            field_120_fcClx = LittleEndian.GetInt(data, 0x1a2 + offset);
            field_121_lcbClx = LittleEndian.GetInt(data, 0x1a6 + offset);
            field_122_fcPlcfpgdFtn = LittleEndian.GetInt(data, 0x1aa + offset);
            field_123_lcbPlcfpgdFtn = LittleEndian.GetInt(data, 0x1ae + offset);
            field_124_fcAutosaveSource = LittleEndian.GetInt(data, 0x1b2 + offset);
            field_125_lcbAutosaveSource = LittleEndian.GetInt(data, 0x1b6 + offset);
            field_126_fcGrpXstAtnOwners = LittleEndian.GetInt(data, 0x1ba + offset);
            field_127_lcbGrpXstAtnOwners = LittleEndian.GetInt(data, 0x1be + offset);
            field_128_fcSttbfAtnbkmk = LittleEndian.GetInt(data, 0x1c2 + offset);
            field_129_lcbSttbfAtnbkmk = LittleEndian.GetInt(data, 0x1c6 + offset);
            field_130_fcPlcdoaMom = LittleEndian.GetInt(data, 0x1ca + offset);
            field_131_lcbPlcdoaMom = LittleEndian.GetInt(data, 0x1ce + offset);
            field_132_fcPlcdoaHdr = LittleEndian.GetInt(data, 0x1d2 + offset);
            field_133_lcbPlcdoaHdr = LittleEndian.GetInt(data, 0x1d6 + offset);
            field_134_fcPlcspaMom = LittleEndian.GetInt(data, 0x1da + offset);
            field_135_lcbPlcspaMom = LittleEndian.GetInt(data, 0x1de + offset);
            field_136_fcPlcspaHdr = LittleEndian.GetInt(data, 0x1e2 + offset);
            field_137_lcbPlcspaHdr = LittleEndian.GetInt(data, 0x1e6 + offset);
            field_138_fcPlcfAtnbkf = LittleEndian.GetInt(data, 0x1ea + offset);
            field_139_lcbPlcfAtnbkf = LittleEndian.GetInt(data, 0x1ee + offset);
            field_140_fcPlcfAtnbkl = LittleEndian.GetInt(data, 0x1f2 + offset);
            field_141_lcbPlcfAtnbkl = LittleEndian.GetInt(data, 0x1f6 + offset);
            field_142_fcPms = LittleEndian.GetInt(data, 0x1fa + offset);
            field_143_lcbPms = LittleEndian.GetInt(data, 0x1fe + offset);
            field_144_fcFormFldSttbs = LittleEndian.GetInt(data, 0x202 + offset);
            field_145_lcbFormFldSttbs = LittleEndian.GetInt(data, 0x206 + offset);
            field_146_fcPlcfendRef = LittleEndian.GetInt(data, 0x20a + offset);
            field_147_lcbPlcfendRef = LittleEndian.GetInt(data, 0x20e + offset);
            field_148_fcPlcfendTxt = LittleEndian.GetInt(data, 0x212 + offset);
            field_149_lcbPlcfendTxt = LittleEndian.GetInt(data, 0x216 + offset);
            field_150_fcPlcffldEdn = LittleEndian.GetInt(data, 0x21a + offset);
            field_151_lcbPlcffldEdn = LittleEndian.GetInt(data, 0x21e + offset);
            field_152_fcPlcfpgdEdn = LittleEndian.GetInt(data, 0x222 + offset);
            field_153_lcbPlcfpgdEdn = LittleEndian.GetInt(data, 0x226 + offset);
            field_154_fcDggInfo = LittleEndian.GetInt(data, 0x22a + offset);
            field_155_lcbDggInfo = LittleEndian.GetInt(data, 0x22e + offset);
            field_156_fcSttbfRMark = LittleEndian.GetInt(data, 0x232 + offset);
            field_157_lcbSttbfRMark = LittleEndian.GetInt(data, 0x236 + offset);
            field_158_fcSttbCaption = LittleEndian.GetInt(data, 0x23a + offset);
            field_159_lcbSttbCaption = LittleEndian.GetInt(data, 0x23e + offset);
            field_160_fcSttbAutoCaption = LittleEndian.GetInt(data, 0x242 + offset);
            field_161_lcbSttbAutoCaption = LittleEndian.GetInt(data, 0x246 + offset);
            field_162_fcPlcfwkb = LittleEndian.GetInt(data, 0x24a + offset);
            field_163_lcbPlcfwkb = LittleEndian.GetInt(data, 0x24e + offset);
            field_164_fcPlcfspl = LittleEndian.GetInt(data, 0x252 + offset);
            field_165_lcbPlcfspl = LittleEndian.GetInt(data, 0x256 + offset);
            field_166_fcPlcftxbxTxt = LittleEndian.GetInt(data, 0x25a + offset);
            field_167_lcbPlcftxbxTxt = LittleEndian.GetInt(data, 0x25e + offset);
            field_168_fcPlcffldTxbx = LittleEndian.GetInt(data, 0x262 + offset);
            field_169_lcbPlcffldTxbx = LittleEndian.GetInt(data, 0x266 + offset);
            field_170_fcPlcfhdrtxbxTxt = LittleEndian.GetInt(data, 0x26a + offset);
            field_171_lcbPlcfhdrtxbxTxt = LittleEndian.GetInt(data, 0x26e + offset);
            field_172_fcPlcffldHdrTxbx = LittleEndian.GetInt(data, 0x272 + offset);
            field_173_lcbPlcffldHdrTxbx = LittleEndian.GetInt(data, 0x276 + offset);
            field_174_fcStwUser = LittleEndian.GetInt(data, 0x27a + offset);
            field_175_lcbStwUser = LittleEndian.GetInt(data, 0x27e + offset);
            field_176_fcSttbttmbd = LittleEndian.GetInt(data, 0x282 + offset);
            field_177_cbSttbttmbd = LittleEndian.GetInt(data, 0x286 + offset);
            field_178_fcUnused = LittleEndian.GetInt(data, 0x28a + offset);
            field_179_lcbUnused = LittleEndian.GetInt(data, 0x28e + offset);
            field_180_fcPgdMother = LittleEndian.GetInt(data, 0x292 + offset);
            field_181_lcbPgdMother = LittleEndian.GetInt(data, 0x296 + offset);
            field_182_fcBkdMother = LittleEndian.GetInt(data, 0x29a + offset);
            field_183_lcbBkdMother = LittleEndian.GetInt(data, 0x29e + offset);
            field_184_fcPgdFtn = LittleEndian.GetInt(data, 0x2a2 + offset);
            field_185_lcbPgdFtn = LittleEndian.GetInt(data, 0x2a6 + offset);
            field_186_fcBkdFtn = LittleEndian.GetInt(data, 0x2aa + offset);
            field_187_lcbBkdFtn = LittleEndian.GetInt(data, 0x2ae + offset);
            field_188_fcPgdEdn = LittleEndian.GetInt(data, 0x2b2 + offset);
            field_189_lcbPgdEdn = LittleEndian.GetInt(data, 0x2b6 + offset);
            field_190_fcBkdEdn = LittleEndian.GetInt(data, 0x2ba + offset);
            field_191_lcbBkdEdn = LittleEndian.GetInt(data, 0x2be + offset);
            field_192_fcSttbfIntlFld = LittleEndian.GetInt(data, 0x2c2 + offset);
            field_193_lcbSttbfIntlFld = LittleEndian.GetInt(data, 0x2c6 + offset);
            field_194_fcRouteSlip = LittleEndian.GetInt(data, 0x2ca + offset);
            field_195_lcbRouteSlip = LittleEndian.GetInt(data, 0x2ce + offset);
            field_196_fcSttbSavedBy = LittleEndian.GetInt(data, 0x2d2 + offset);
            field_197_lcbSttbSavedBy = LittleEndian.GetInt(data, 0x2d6 + offset);
            field_198_fcSttbFnm = LittleEndian.GetInt(data, 0x2da + offset);
            field_199_lcbSttbFnm = LittleEndian.GetInt(data, 0x2de + offset);
            field_200_fcPlcfLst = LittleEndian.GetInt(data, 0x2e2 + offset);
            field_201_lcbPlcfLst = LittleEndian.GetInt(data, 0x2e6 + offset);
            field_202_fcPlfLfo = LittleEndian.GetInt(data, 0x2ea + offset);
            field_203_lcbPlfLfo = LittleEndian.GetInt(data, 0x2ee + offset);
            field_204_fcPlcftxbxBkd = LittleEndian.GetInt(data, 0x2f2 + offset);
            field_205_lcbPlcftxbxBkd = LittleEndian.GetInt(data, 0x2f6 + offset);
            field_206_fcPlcftxbxHdrBkd = LittleEndian.GetInt(data, 0x2fa + offset);
            field_207_lcbPlcftxbxHdrBkd = LittleEndian.GetInt(data, 0x2fe + offset);
            field_208_fcDocUndo = LittleEndian.GetInt(data, 0x302 + offset);
            field_209_lcbDocUndo = LittleEndian.GetInt(data, 0x306 + offset);
            field_210_fcRgbuse = LittleEndian.GetInt(data, 0x30a + offset);
            field_211_lcbRgbuse = LittleEndian.GetInt(data, 0x30e + offset);
            field_212_fcUsp = LittleEndian.GetInt(data, 0x312 + offset);
            field_213_lcbUsp = LittleEndian.GetInt(data, 0x316 + offset);
            field_214_fcUskf = LittleEndian.GetInt(data, 0x31a + offset);
            field_215_lcbUskf = LittleEndian.GetInt(data, 0x31e + offset);
            field_216_fcPlcupcRgbuse = LittleEndian.GetInt(data, 0x322 + offset);
            field_217_lcbPlcupcRgbuse = LittleEndian.GetInt(data, 0x326 + offset);
            field_218_fcPlcupcUsp = LittleEndian.GetInt(data, 0x32a + offset);
            field_219_lcbPlcupcUsp = LittleEndian.GetInt(data, 0x32e + offset);
            field_220_fcSttbGlsyStyle = LittleEndian.GetInt(data, 0x332 + offset);
            field_221_lcbSttbGlsyStyle = LittleEndian.GetInt(data, 0x336 + offset);
            field_222_fcPlgosl = LittleEndian.GetInt(data, 0x33a + offset);
            field_223_lcbPlgosl = LittleEndian.GetInt(data, 0x33e + offset);
            field_224_fcPlcocx = LittleEndian.GetInt(data, 0x342 + offset);
            field_225_lcbPlcocx = LittleEndian.GetInt(data, 0x346 + offset);
            field_226_fcPlcfbteLvc = LittleEndian.GetInt(data, 0x34a + offset);
            field_227_lcbPlcfbteLvc = LittleEndian.GetInt(data, 0x34e + offset);
            field_228_dwLowDateTime = LittleEndian.GetInt(data, 0x352 + offset);
            field_229_dwHighDateTime = LittleEndian.GetInt(data, 0x356 + offset);
            field_230_fcPlcflvc = LittleEndian.GetInt(data, 0x35a + offset);
            field_231_lcbPlcflvc = LittleEndian.GetInt(data, 0x35e + offset);
            field_232_fcPlcasumy = LittleEndian.GetInt(data, 0x362 + offset);
            field_233_lcbPlcasumy = LittleEndian.GetInt(data, 0x366 + offset);
            field_234_fcPlcfgram = LittleEndian.GetInt(data, 0x36a + offset);
            field_235_lcbPlcfgram = LittleEndian.GetInt(data, 0x36e + offset);
            field_236_fcSttbListNames = LittleEndian.GetInt(data, 0x372 + offset);
            field_237_lcbSttbListNames = LittleEndian.GetInt(data, 0x376 + offset);
            field_238_fcSttbfUssr = LittleEndian.GetInt(data, 0x37a + offset);
            field_239_lcbSttbfUssr = LittleEndian.GetInt(data, 0x37e + offset);

        }

        public void serialize(byte[] data, int offset)
        {
            LittleEndian.PutShort(data, 0x0 + offset, (short)field_1_wIdent); ;
            LittleEndian.PutShort(data, 0x2 + offset, (short)field_2_nFib); ;
            LittleEndian.PutShort(data, 0x4 + offset, (short)field_3_nProduct); ;
            LittleEndian.PutShort(data, 0x6 + offset, (short)field_4_lid); ;
            LittleEndian.PutShort(data, 0x8 + offset, (short)field_5_pnNext); ;
            LittleEndian.PutShort(data, 0xa + offset, (short)field_6_options); ;
            LittleEndian.PutShort(data, 0xc + offset, (short)field_7_nFibBack); ;
            LittleEndian.PutShort(data, 0xe + offset, (short)field_8_lKey); ;
            LittleEndian.PutShort(data, 0x10 + offset, (short)field_9_envr); ;
            LittleEndian.PutShort(data, 0x12 + offset, (short)field_10_history); ;
            LittleEndian.PutShort(data, 0x14 + offset, (short)field_11_chs); ;
            LittleEndian.PutShort(data, 0x16 + offset, (short)field_12_chsTables); ;
            LittleEndian.PutInt(data, 0x18 + offset, field_13_fcMin); ;
            LittleEndian.PutInt(data, 0x1c + offset, field_14_fcMac); ;
            LittleEndian.PutShort(data, 0x20 + offset, (short)field_15_csw); ;
            LittleEndian.PutShort(data, 0x22 + offset, (short)field_16_wMagicCreated); ;
            LittleEndian.PutShort(data, 0x24 + offset, (short)field_17_wMagicRevised); ;
            LittleEndian.PutShort(data, 0x26 + offset, (short)field_18_wMagicCreatedPrivate); ;
            LittleEndian.PutShort(data, 0x28 + offset, (short)field_19_wMagicRevisedPrivate); ;
            LittleEndian.PutShort(data, 0x2a + offset, (short)field_20_pnFbpChpFirst_W6); ;
            LittleEndian.PutShort(data, 0x2c + offset, (short)field_21_pnChpFirst_W6); ;
            LittleEndian.PutShort(data, 0x2e + offset, (short)field_22_cpnBteChp_W6); ;
            LittleEndian.PutShort(data, 0x30 + offset, (short)field_23_pnFbpPapFirst_W6); ;
            LittleEndian.PutShort(data, 0x32 + offset, (short)field_24_pnPapFirst_W6); ;
            LittleEndian.PutShort(data, 0x34 + offset, (short)field_25_cpnBtePap_W6); ;
            LittleEndian.PutShort(data, 0x36 + offset, (short)field_26_pnFbpLvcFirst_W6); ;
            LittleEndian.PutShort(data, 0x38 + offset, (short)field_27_pnLvcFirst_W6); ;
            LittleEndian.PutShort(data, 0x3a + offset, (short)field_28_cpnBteLvc_W6); ;
            LittleEndian.PutShort(data, 0x3c + offset, (short)field_29_lidFE); ;
            LittleEndian.PutShort(data, 0x3e + offset, (short)field_30_clw); ;
            LittleEndian.PutInt(data, 0x40 + offset, field_31_cbMac); ;
            LittleEndian.PutInt(data, 0x44 + offset, field_32_lProductCreated); ;
            LittleEndian.PutInt(data, 0x48 + offset, field_33_lProductRevised); ;
            LittleEndian.PutInt(data, 0x4c + offset, field_34_ccpText); ;
            LittleEndian.PutInt(data, 0x50 + offset, field_35_ccpFtn); ;
            LittleEndian.PutInt(data, 0x54 + offset, field_36_ccpHdd); ;
            LittleEndian.PutInt(data, 0x58 + offset, field_37_ccpMcr); ;
            LittleEndian.PutInt(data, 0x5c + offset, field_38_ccpAtn); ;
            LittleEndian.PutInt(data, 0x60 + offset, field_39_ccpEdn); ;
            LittleEndian.PutInt(data, 0x64 + offset, field_40_ccpTxbx); ;
            LittleEndian.PutInt(data, 0x68 + offset, field_41_ccpHdrTxbx); ;
            LittleEndian.PutInt(data, 0x6c + offset, field_42_pnFbpChpFirst); ;
            LittleEndian.PutInt(data, 0x70 + offset, field_43_pnChpFirst); ;
            LittleEndian.PutInt(data, 0x74 + offset, field_44_cpnBteChp); ;
            LittleEndian.PutInt(data, 0x78 + offset, field_45_pnFbpPapFirst); ;
            LittleEndian.PutInt(data, 0x7c + offset, field_46_pnPapFirst); ;
            LittleEndian.PutInt(data, 0x80 + offset, field_47_cpnBtePap); ;
            LittleEndian.PutInt(data, 0x84 + offset, field_48_pnFbpLvcFirst); ;
            LittleEndian.PutInt(data, 0x88 + offset, field_49_pnLvcFirst); ;
            LittleEndian.PutInt(data, 0x8c + offset, field_50_cpnBteLvc); ;
            LittleEndian.PutInt(data, 0x90 + offset, field_51_fcIslandFirst); ;
            LittleEndian.PutInt(data, 0x94 + offset, field_52_fcIslandLim); ;
            LittleEndian.PutShort(data, 0x98 + offset, (short)field_53_cfclcb); ;
            LittleEndian.PutInt(data, 0x9a + offset, field_54_fcStshfOrig); ;
            LittleEndian.PutInt(data, 0x9e + offset, field_55_lcbStshfOrig); ;
            LittleEndian.PutInt(data, 0xa2 + offset, field_56_fcStshf); ;
            LittleEndian.PutInt(data, 0xa6 + offset, field_57_lcbStshf); ;
            LittleEndian.PutInt(data, 0xaa + offset, field_58_fcPlcffndRef); ;
            LittleEndian.PutInt(data, 0xae + offset, field_59_lcbPlcffndRef); ;
            LittleEndian.PutInt(data, 0xb2 + offset, field_60_fcPlcffndTxt); ;
            LittleEndian.PutInt(data, 0xb6 + offset, field_61_lcbPlcffndTxt); ;
            LittleEndian.PutInt(data, 0xba + offset, field_62_fcPlcfandRef); ;
            LittleEndian.PutInt(data, 0xbe + offset, field_63_lcbPlcfandRef); ;
            LittleEndian.PutInt(data, 0xc2 + offset, field_64_fcPlcfandTxt); ;
            LittleEndian.PutInt(data, 0xc6 + offset, field_65_lcbPlcfandTxt); ;
            LittleEndian.PutInt(data, 0xca + offset, field_66_fcPlcfsed); ;
            LittleEndian.PutInt(data, 0xce + offset, field_67_lcbPlcfsed); ;
            LittleEndian.PutInt(data, 0xd2 + offset, field_68_fcPlcpad); ;
            LittleEndian.PutInt(data, 0xd6 + offset, field_69_lcbPlcpad); ;
            LittleEndian.PutInt(data, 0xda + offset, field_70_fcPlcfphe); ;
            LittleEndian.PutInt(data, 0xde + offset, field_71_lcbPlcfphe); ;
            LittleEndian.PutInt(data, 0xe2 + offset, field_72_fcSttbfglsy); ;
            LittleEndian.PutInt(data, 0xe6 + offset, field_73_lcbSttbfglsy); ;
            LittleEndian.PutInt(data, 0xea + offset, field_74_fcPlcfglsy); ;
            LittleEndian.PutInt(data, 0xee + offset, field_75_lcbPlcfglsy); ;
            LittleEndian.PutInt(data, 0xf2 + offset, field_76_fcPlcfhdd); ;
            LittleEndian.PutInt(data, 0xf6 + offset, field_77_lcbPlcfhdd); ;
            LittleEndian.PutInt(data, 0xfa + offset, field_78_fcPlcfbteChpx); ;
            LittleEndian.PutInt(data, 0xfe + offset, field_79_lcbPlcfbteChpx); ;
            LittleEndian.PutInt(data, 0x102 + offset, field_80_fcPlcfbtePapx); ;
            LittleEndian.PutInt(data, 0x106 + offset, field_81_lcbPlcfbtePapx); ;
            LittleEndian.PutInt(data, 0x10a + offset, field_82_fcPlcfsea); ;
            LittleEndian.PutInt(data, 0x10e + offset, field_83_lcbPlcfsea); ;
            LittleEndian.PutInt(data, 0x112 + offset, field_84_fcSttbfffn); ;
            LittleEndian.PutInt(data, 0x116 + offset, field_85_lcbSttbfffn); ;
            LittleEndian.PutInt(data, 0x11a + offset, field_86_fcPlcffldMom); ;
            LittleEndian.PutInt(data, 0x11e + offset, field_87_lcbPlcffldMom); ;
            LittleEndian.PutInt(data, 0x122 + offset, field_88_fcPlcffldHdr); ;
            LittleEndian.PutInt(data, 0x126 + offset, field_89_lcbPlcffldHdr); ;
            LittleEndian.PutInt(data, 0x12a + offset, field_90_fcPlcffldFtn); ;
            LittleEndian.PutInt(data, 0x12e + offset, field_91_lcbPlcffldFtn); ;
            LittleEndian.PutInt(data, 0x132 + offset, field_92_fcPlcffldAtn); ;
            LittleEndian.PutInt(data, 0x136 + offset, field_93_lcbPlcffldAtn); ;
            LittleEndian.PutInt(data, 0x13a + offset, field_94_fcPlcffldMcr); ;
            LittleEndian.PutInt(data, 0x13e + offset, field_95_lcbPlcffldMcr); ;
            LittleEndian.PutInt(data, 0x142 + offset, field_96_fcSttbfbkmk); ;
            LittleEndian.PutInt(data, 0x146 + offset, field_97_lcbSttbfbkmk); ;
            LittleEndian.PutInt(data, 0x14a + offset, field_98_fcPlcfbkf); ;
            LittleEndian.PutInt(data, 0x14e + offset, field_99_lcbPlcfbkf); ;
            LittleEndian.PutInt(data, 0x152 + offset, field_100_fcPlcfbkl); ;
            LittleEndian.PutInt(data, 0x156 + offset, field_101_lcbPlcfbkl); ;
            LittleEndian.PutInt(data, 0x15a + offset, field_102_fcCmds); ;
            LittleEndian.PutInt(data, 0x15e + offset, field_103_lcbCmds); ;
            LittleEndian.PutInt(data, 0x162 + offset, field_104_fcPlcmcr); ;
            LittleEndian.PutInt(data, 0x166 + offset, field_105_lcbPlcmcr); ;
            LittleEndian.PutInt(data, 0x16a + offset, field_106_fcSttbfmcr); ;
            LittleEndian.PutInt(data, 0x16e + offset, field_107_lcbSttbfmcr); ;
            LittleEndian.PutInt(data, 0x172 + offset, field_108_fcPrDrvr); ;
            LittleEndian.PutInt(data, 0x176 + offset, field_109_lcbPrDrvr); ;
            LittleEndian.PutInt(data, 0x17a + offset, field_110_fcPrEnvPort); ;
            LittleEndian.PutInt(data, 0x17e + offset, field_111_lcbPrEnvPort); ;
            LittleEndian.PutInt(data, 0x182 + offset, field_112_fcPrEnvLand); ;
            LittleEndian.PutInt(data, 0x186 + offset, field_113_lcbPrEnvLand); ;
            LittleEndian.PutInt(data, 0x18a + offset, field_114_fcWss); ;
            LittleEndian.PutInt(data, 0x18e + offset, field_115_lcbWss); ;
            LittleEndian.PutInt(data, 0x192 + offset, field_116_fcDop); ;
            LittleEndian.PutInt(data, 0x196 + offset, field_117_lcbDop); ;
            LittleEndian.PutInt(data, 0x19a + offset, field_118_fcSttbfAssoc); ;
            LittleEndian.PutInt(data, 0x19e + offset, field_119_lcbSttbfAssoc); ;
            LittleEndian.PutInt(data, 0x1a2 + offset, field_120_fcClx); ;
            LittleEndian.PutInt(data, 0x1a6 + offset, field_121_lcbClx); ;
            LittleEndian.PutInt(data, 0x1aa + offset, field_122_fcPlcfpgdFtn); ;
            LittleEndian.PutInt(data, 0x1ae + offset, field_123_lcbPlcfpgdFtn); ;
            LittleEndian.PutInt(data, 0x1b2 + offset, field_124_fcAutosaveSource); ;
            LittleEndian.PutInt(data, 0x1b6 + offset, field_125_lcbAutosaveSource); ;
            LittleEndian.PutInt(data, 0x1ba + offset, field_126_fcGrpXstAtnOwners); ;
            LittleEndian.PutInt(data, 0x1be + offset, field_127_lcbGrpXstAtnOwners); ;
            LittleEndian.PutInt(data, 0x1c2 + offset, field_128_fcSttbfAtnbkmk); ;
            LittleEndian.PutInt(data, 0x1c6 + offset, field_129_lcbSttbfAtnbkmk); ;
            LittleEndian.PutInt(data, 0x1ca + offset, field_130_fcPlcdoaMom); ;
            LittleEndian.PutInt(data, 0x1ce + offset, field_131_lcbPlcdoaMom); ;
            LittleEndian.PutInt(data, 0x1d2 + offset, field_132_fcPlcdoaHdr); ;
            LittleEndian.PutInt(data, 0x1d6 + offset, field_133_lcbPlcdoaHdr); ;
            LittleEndian.PutInt(data, 0x1da + offset, field_134_fcPlcspaMom); ;
            LittleEndian.PutInt(data, 0x1de + offset, field_135_lcbPlcspaMom); ;
            LittleEndian.PutInt(data, 0x1e2 + offset, field_136_fcPlcspaHdr); ;
            LittleEndian.PutInt(data, 0x1e6 + offset, field_137_lcbPlcspaHdr); ;
            LittleEndian.PutInt(data, 0x1ea + offset, field_138_fcPlcfAtnbkf); ;
            LittleEndian.PutInt(data, 0x1ee + offset, field_139_lcbPlcfAtnbkf); ;
            LittleEndian.PutInt(data, 0x1f2 + offset, field_140_fcPlcfAtnbkl); ;
            LittleEndian.PutInt(data, 0x1f6 + offset, field_141_lcbPlcfAtnbkl); ;
            LittleEndian.PutInt(data, 0x1fa + offset, field_142_fcPms); ;
            LittleEndian.PutInt(data, 0x1fe + offset, field_143_lcbPms); ;
            LittleEndian.PutInt(data, 0x202 + offset, field_144_fcFormFldSttbs); ;
            LittleEndian.PutInt(data, 0x206 + offset, field_145_lcbFormFldSttbs); ;
            LittleEndian.PutInt(data, 0x20a + offset, field_146_fcPlcfendRef); ;
            LittleEndian.PutInt(data, 0x20e + offset, field_147_lcbPlcfendRef); ;
            LittleEndian.PutInt(data, 0x212 + offset, field_148_fcPlcfendTxt); ;
            LittleEndian.PutInt(data, 0x216 + offset, field_149_lcbPlcfendTxt); ;
            LittleEndian.PutInt(data, 0x21a + offset, field_150_fcPlcffldEdn); ;
            LittleEndian.PutInt(data, 0x21e + offset, field_151_lcbPlcffldEdn); ;
            LittleEndian.PutInt(data, 0x222 + offset, field_152_fcPlcfpgdEdn); ;
            LittleEndian.PutInt(data, 0x226 + offset, field_153_lcbPlcfpgdEdn); ;
            LittleEndian.PutInt(data, 0x22a + offset, field_154_fcDggInfo); ;
            LittleEndian.PutInt(data, 0x22e + offset, field_155_lcbDggInfo); ;
            LittleEndian.PutInt(data, 0x232 + offset, field_156_fcSttbfRMark); ;
            LittleEndian.PutInt(data, 0x236 + offset, field_157_lcbSttbfRMark); ;
            LittleEndian.PutInt(data, 0x23a + offset, field_158_fcSttbCaption); ;
            LittleEndian.PutInt(data, 0x23e + offset, field_159_lcbSttbCaption); ;
            LittleEndian.PutInt(data, 0x242 + offset, field_160_fcSttbAutoCaption); ;
            LittleEndian.PutInt(data, 0x246 + offset, field_161_lcbSttbAutoCaption); ;
            LittleEndian.PutInt(data, 0x24a + offset, field_162_fcPlcfwkb); ;
            LittleEndian.PutInt(data, 0x24e + offset, field_163_lcbPlcfwkb); ;
            LittleEndian.PutInt(data, 0x252 + offset, field_164_fcPlcfspl); ;
            LittleEndian.PutInt(data, 0x256 + offset, field_165_lcbPlcfspl); ;
            LittleEndian.PutInt(data, 0x25a + offset, field_166_fcPlcftxbxTxt); ;
            LittleEndian.PutInt(data, 0x25e + offset, field_167_lcbPlcftxbxTxt); ;
            LittleEndian.PutInt(data, 0x262 + offset, field_168_fcPlcffldTxbx); ;
            LittleEndian.PutInt(data, 0x266 + offset, field_169_lcbPlcffldTxbx); ;
            LittleEndian.PutInt(data, 0x26a + offset, field_170_fcPlcfhdrtxbxTxt); ;
            LittleEndian.PutInt(data, 0x26e + offset, field_171_lcbPlcfhdrtxbxTxt); ;
            LittleEndian.PutInt(data, 0x272 + offset, field_172_fcPlcffldHdrTxbx); ;
            LittleEndian.PutInt(data, 0x276 + offset, field_173_lcbPlcffldHdrTxbx); ;
            LittleEndian.PutInt(data, 0x27a + offset, field_174_fcStwUser); ;
            LittleEndian.PutInt(data, 0x27e + offset, field_175_lcbStwUser); ;
            LittleEndian.PutInt(data, 0x282 + offset, field_176_fcSttbttmbd); ;
            LittleEndian.PutInt(data, 0x286 + offset, field_177_cbSttbttmbd); ;
            LittleEndian.PutInt(data, 0x28a + offset, field_178_fcUnused); ;
            LittleEndian.PutInt(data, 0x28e + offset, field_179_lcbUnused); ;
            LittleEndian.PutInt(data, 0x292 + offset, field_180_fcPgdMother); ;
            LittleEndian.PutInt(data, 0x296 + offset, field_181_lcbPgdMother); ;
            LittleEndian.PutInt(data, 0x29a + offset, field_182_fcBkdMother); ;
            LittleEndian.PutInt(data, 0x29e + offset, field_183_lcbBkdMother); ;
            LittleEndian.PutInt(data, 0x2a2 + offset, field_184_fcPgdFtn); ;
            LittleEndian.PutInt(data, 0x2a6 + offset, field_185_lcbPgdFtn); ;
            LittleEndian.PutInt(data, 0x2aa + offset, field_186_fcBkdFtn); ;
            LittleEndian.PutInt(data, 0x2ae + offset, field_187_lcbBkdFtn); ;
            LittleEndian.PutInt(data, 0x2b2 + offset, field_188_fcPgdEdn); ;
            LittleEndian.PutInt(data, 0x2b6 + offset, field_189_lcbPgdEdn); ;
            LittleEndian.PutInt(data, 0x2ba + offset, field_190_fcBkdEdn); ;
            LittleEndian.PutInt(data, 0x2be + offset, field_191_lcbBkdEdn); ;
            LittleEndian.PutInt(data, 0x2c2 + offset, field_192_fcSttbfIntlFld); ;
            LittleEndian.PutInt(data, 0x2c6 + offset, field_193_lcbSttbfIntlFld); ;
            LittleEndian.PutInt(data, 0x2ca + offset, field_194_fcRouteSlip); ;
            LittleEndian.PutInt(data, 0x2ce + offset, field_195_lcbRouteSlip); ;
            LittleEndian.PutInt(data, 0x2d2 + offset, field_196_fcSttbSavedBy); ;
            LittleEndian.PutInt(data, 0x2d6 + offset, field_197_lcbSttbSavedBy); ;
            LittleEndian.PutInt(data, 0x2da + offset, field_198_fcSttbFnm); ;
            LittleEndian.PutInt(data, 0x2de + offset, field_199_lcbSttbFnm); ;
            LittleEndian.PutInt(data, 0x2e2 + offset, field_200_fcPlcfLst); ;
            LittleEndian.PutInt(data, 0x2e6 + offset, field_201_lcbPlcfLst); ;
            LittleEndian.PutInt(data, 0x2ea + offset, field_202_fcPlfLfo); ;
            LittleEndian.PutInt(data, 0x2ee + offset, field_203_lcbPlfLfo); ;
            LittleEndian.PutInt(data, 0x2f2 + offset, field_204_fcPlcftxbxBkd); ;
            LittleEndian.PutInt(data, 0x2f6 + offset, field_205_lcbPlcftxbxBkd); ;
            LittleEndian.PutInt(data, 0x2fa + offset, field_206_fcPlcftxbxHdrBkd); ;
            LittleEndian.PutInt(data, 0x2fe + offset, field_207_lcbPlcftxbxHdrBkd); ;
            LittleEndian.PutInt(data, 0x302 + offset, field_208_fcDocUndo); ;
            LittleEndian.PutInt(data, 0x306 + offset, field_209_lcbDocUndo); ;
            LittleEndian.PutInt(data, 0x30a + offset, field_210_fcRgbuse); ;
            LittleEndian.PutInt(data, 0x30e + offset, field_211_lcbRgbuse); ;
            LittleEndian.PutInt(data, 0x312 + offset, field_212_fcUsp); ;
            LittleEndian.PutInt(data, 0x316 + offset, field_213_lcbUsp); ;
            LittleEndian.PutInt(data, 0x31a + offset, field_214_fcUskf); ;
            LittleEndian.PutInt(data, 0x31e + offset, field_215_lcbUskf); ;
            LittleEndian.PutInt(data, 0x322 + offset, field_216_fcPlcupcRgbuse); ;
            LittleEndian.PutInt(data, 0x326 + offset, field_217_lcbPlcupcRgbuse); ;
            LittleEndian.PutInt(data, 0x32a + offset, field_218_fcPlcupcUsp); ;
            LittleEndian.PutInt(data, 0x32e + offset, field_219_lcbPlcupcUsp); ;
            LittleEndian.PutInt(data, 0x332 + offset, field_220_fcSttbGlsyStyle); ;
            LittleEndian.PutInt(data, 0x336 + offset, field_221_lcbSttbGlsyStyle); ;
            LittleEndian.PutInt(data, 0x33a + offset, field_222_fcPlgosl); ;
            LittleEndian.PutInt(data, 0x33e + offset, field_223_lcbPlgosl); ;
            LittleEndian.PutInt(data, 0x342 + offset, field_224_fcPlcocx); ;
            LittleEndian.PutInt(data, 0x346 + offset, field_225_lcbPlcocx); ;
            LittleEndian.PutInt(data, 0x34a + offset, field_226_fcPlcfbteLvc); ;
            LittleEndian.PutInt(data, 0x34e + offset, field_227_lcbPlcfbteLvc); ;
            LittleEndian.PutInt(data, 0x352 + offset, field_228_dwLowDateTime); ;
            LittleEndian.PutInt(data, 0x356 + offset, field_229_dwHighDateTime); ;
            LittleEndian.PutInt(data, 0x35a + offset, field_230_fcPlcflvc); ;
            LittleEndian.PutInt(data, 0x35e + offset, field_231_lcbPlcflvc); ;
            LittleEndian.PutInt(data, 0x362 + offset, field_232_fcPlcasumy); ;
            LittleEndian.PutInt(data, 0x366 + offset, field_233_lcbPlcasumy); ;
            LittleEndian.PutInt(data, 0x36a + offset, field_234_fcPlcfgram); ;
            LittleEndian.PutInt(data, 0x36e + offset, field_235_lcbPlcfgram); ;
            LittleEndian.PutInt(data, 0x372 + offset, field_236_fcSttbListNames); ;
            LittleEndian.PutInt(data, 0x376 + offset, field_237_lcbSttbListNames); ;
            LittleEndian.PutInt(data, 0x37a + offset, field_238_fcSttbfUssr); ;
            LittleEndian.PutInt(data, 0x37e + offset, field_239_lcbSttbfUssr); ;

        }

        public String ToString()
        {
            StringBuilder buffer = new StringBuilder();

            buffer.Append("[FIB]\n");

            buffer.Append("    .wIdent               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetWIdent()));
            buffer.Append(" (").Append(GetWIdent()).Append(" )\n");

            buffer.Append("    .nFib                 = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetNFib()));
            buffer.Append(" (").Append(GetNFib()).Append(" )\n");

            buffer.Append("    .nProduct             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetNProduct()));
            buffer.Append(" (").Append(GetNProduct()).Append(" )\n");

            buffer.Append("    .lid                  = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLid()));
            buffer.Append(" (").Append(GetLid()).Append(" )\n");

            buffer.Append("    .pnNext               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnNext()));
            buffer.Append(" (").Append(GetPnNext()).Append(" )\n");

            buffer.Append("    .options              = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((short)GetOptions()));
            buffer.Append(" (").Append(GetOptions()).Append(" )\n");
            buffer.Append("         .fDot                     = ").Append(IsFDot()).Append('\n');
            buffer.Append("         .fGlsy                    = ").Append(IsFGlsy()).Append('\n');
            buffer.Append("         .fComplex                 = ").Append(IsFComplex()).Append('\n');
            buffer.Append("         .fHasPic                  = ").Append(IsFHasPic()).Append('\n');
            buffer.Append("         .cQuickSaves              = ").Append(GetCQuickSaves()).Append('\n');
            buffer.Append("         .fEncrypted               = ").Append(IsFEncrypted()).Append('\n');
            buffer.Append("         .fWhichTblStm             = ").Append(IsFWhichTblStm()).Append('\n');
            buffer.Append("         .fReadOnlyRecommended     = ").Append(IsFReadOnlyRecommended()).Append('\n');
            buffer.Append("         .fWriteReservation        = ").Append(IsFWriteReservation()).Append('\n');
            buffer.Append("         .fExtChar                 = ").Append(IsFExtChar()).Append('\n');
            buffer.Append("         .fLoadOverride            = ").Append(IsFLoadOverride()).Append('\n');
            buffer.Append("         .fFarEast                 = ").Append(IsFFarEast()).Append('\n');
            buffer.Append("         .fCrypto                  = ").Append(IsFCrypto()).Append('\n');

            buffer.Append("    .nFibBack             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetNFibBack()));
            buffer.Append(" (").Append(GetNFibBack()).Append(" )\n");

            buffer.Append("    .lKey                 = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLKey()));
            buffer.Append(" (").Append(GetLKey()).Append(" )\n");

            buffer.Append("    .envr                 = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetEnvr()));
            buffer.Append(" (").Append(GetEnvr()).Append(" )\n");

            buffer.Append("    .history              = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((short)GetHistory()));
            buffer.Append(" (").Append(GetHistory()).Append(" )\n");
            buffer.Append("         .fMac                     = ").Append(IsFMac()).Append('\n');
            buffer.Append("         .fEmptySpecial            = ").Append(IsFEmptySpecial()).Append('\n');
            buffer.Append("         .fLoadOverridePage        = ").Append(IsFLoadOverridePage()).Append('\n');
            buffer.Append("         .fFutureSavedUndo         = ").Append(IsFFutureSavedUndo()).Append('\n');
            buffer.Append("         .fWord97Saved             = ").Append(IsFWord97Saved()).Append('\n');
            buffer.Append("         .fSpare0                  = ").Append(GetFSpare0()).Append('\n');

            buffer.Append("    .chs                  = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetChs()));
            buffer.Append(" (").Append(GetChs()).Append(" )\n");

            buffer.Append("    .chsTables            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetChsTables()));
            buffer.Append(" (").Append(GetChsTables()).Append(" )\n");

            buffer.Append("    .fcMin                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcMin()));
            buffer.Append(" (").Append(GetFcMin()).Append(" )\n");

            buffer.Append("    .fcMac                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcMac()));
            buffer.Append(" (").Append(GetFcMac()).Append(" )\n");

            buffer.Append("    .csw                  = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCsw()));
            buffer.Append(" (").Append(GetCsw()).Append(" )\n");

            buffer.Append("    .wMagicCreated        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetWMagicCreated()));
            buffer.Append(" (").Append(GetWMagicCreated()).Append(" )\n");

            buffer.Append("    .wMagicRevised        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetWMagicRevised()));
            buffer.Append(" (").Append(GetWMagicRevised()).Append(" )\n");

            buffer.Append("    .wMagicCreatedPrivate = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetWMagicCreatedPrivate()));
            buffer.Append(" (").Append(GetWMagicCreatedPrivate()).Append(" )\n");

            buffer.Append("    .wMagicRevisedPrivate = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetWMagicRevisedPrivate()));
            buffer.Append(" (").Append(GetWMagicRevisedPrivate()).Append(" )\n");

            buffer.Append("    .pnFbpChpFirst_W6     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnFbpChpFirst_W6()));
            buffer.Append(" (").Append(GetPnFbpChpFirst_W6()).Append(" )\n");

            buffer.Append("    .pnChpFirst_W6        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnChpFirst_W6()));
            buffer.Append(" (").Append(GetPnChpFirst_W6()).Append(" )\n");

            buffer.Append("    .cpnBteChp_W6         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCpnBteChp_W6()));
            buffer.Append(" (").Append(GetCpnBteChp_W6()).Append(" )\n");

            buffer.Append("    .pnFbpPapFirst_W6     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnFbpPapFirst_W6()));
            buffer.Append(" (").Append(GetPnFbpPapFirst_W6()).Append(" )\n");

            buffer.Append("    .pnPapFirst_W6        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnPapFirst_W6()));
            buffer.Append(" (").Append(GetPnPapFirst_W6()).Append(" )\n");

            buffer.Append("    .cpnBtePap_W6         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCpnBtePap_W6()));
            buffer.Append(" (").Append(GetCpnBtePap_W6()).Append(" )\n");

            buffer.Append("    .pnFbpLvcFirst_W6     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnFbpLvcFirst_W6()));
            buffer.Append(" (").Append(GetPnFbpLvcFirst_W6()).Append(" )\n");

            buffer.Append("    .pnLvcFirst_W6        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnLvcFirst_W6()));
            buffer.Append(" (").Append(GetPnLvcFirst_W6()).Append(" )\n");

            buffer.Append("    .cpnBteLvc_W6         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCpnBteLvc_W6()));
            buffer.Append(" (").Append(GetCpnBteLvc_W6()).Append(" )\n");

            buffer.Append("    .lidFE                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLidFE()));
            buffer.Append(" (").Append(GetLidFE()).Append(" )\n");

            buffer.Append("    .clw                  = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetClw()));
            buffer.Append(" (").Append(GetClw()).Append(" )\n");

            buffer.Append("    .cbMac                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCbMac()));
            buffer.Append(" (").Append(GetCbMac()).Append(" )\n");

            buffer.Append("    .lProductCreated      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLProductCreated()));
            buffer.Append(" (").Append(GetLProductCreated()).Append(" )\n");

            buffer.Append("    .lProductRevised      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLProductRevised()));
            buffer.Append(" (").Append(GetLProductRevised()).Append(" )\n");

            buffer.Append("    .ccpText              = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpText()));
            buffer.Append(" (").Append(GetCcpText()).Append(" )\n");

            buffer.Append("    .ccpFtn               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpFtn()));
            buffer.Append(" (").Append(GetCcpFtn()).Append(" )\n");

            buffer.Append("    .ccpHdd               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpHdd()));
            buffer.Append(" (").Append(GetCcpHdd()).Append(" )\n");

            buffer.Append("    .ccpMcr               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpMcr()));
            buffer.Append(" (").Append(GetCcpMcr()).Append(" )\n");

            buffer.Append("    .ccpAtn               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpAtn()));
            buffer.Append(" (").Append(GetCcpAtn()).Append(" )\n");

            buffer.Append("    .ccpEdn               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpEdn()));
            buffer.Append(" (").Append(GetCcpEdn()).Append(" )\n");

            buffer.Append("    .ccpTxbx              = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpTxbx()));
            buffer.Append(" (").Append(GetCcpTxbx()).Append(" )\n");

            buffer.Append("    .ccpHdrTxbx           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCcpHdrTxbx()));
            buffer.Append(" (").Append(GetCcpHdrTxbx()).Append(" )\n");

            buffer.Append("    .pnFbpChpFirst        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnFbpChpFirst()));
            buffer.Append(" (").Append(GetPnFbpChpFirst()).Append(" )\n");

            buffer.Append("    .pnChpFirst           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnChpFirst()));
            buffer.Append(" (").Append(GetPnChpFirst()).Append(" )\n");

            buffer.Append("    .cpnBteChp            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCpnBteChp()));
            buffer.Append(" (").Append(GetCpnBteChp()).Append(" )\n");

            buffer.Append("    .pnFbpPapFirst        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnFbpPapFirst()));
            buffer.Append(" (").Append(GetPnFbpPapFirst()).Append(" )\n");

            buffer.Append("    .pnPapFirst           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnPapFirst()));
            buffer.Append(" (").Append(GetPnPapFirst()).Append(" )\n");

            buffer.Append("    .cpnBtePap            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCpnBtePap()));
            buffer.Append(" (").Append(GetCpnBtePap()).Append(" )\n");

            buffer.Append("    .pnFbpLvcFirst        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnFbpLvcFirst()));
            buffer.Append(" (").Append(GetPnFbpLvcFirst()).Append(" )\n");

            buffer.Append("    .pnLvcFirst           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetPnLvcFirst()));
            buffer.Append(" (").Append(GetPnLvcFirst()).Append(" )\n");

            buffer.Append("    .cpnBteLvc            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCpnBteLvc()));
            buffer.Append(" (").Append(GetCpnBteLvc()).Append(" )\n");

            buffer.Append("    .fcIslandFirst        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcIslandFirst()));
            buffer.Append(" (").Append(GetFcIslandFirst()).Append(" )\n");

            buffer.Append("    .fcIslandLim          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcIslandLim()));
            buffer.Append(" (").Append(GetFcIslandLim()).Append(" )\n");

            buffer.Append("    .cfclcb               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCfclcb()));
            buffer.Append(" (").Append(GetCfclcb()).Append(" )\n");

            buffer.Append("    .fcStshfOrig          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcStshfOrig()));
            buffer.Append(" (").Append(GetFcStshfOrig()).Append(" )\n");

            buffer.Append("    .lcbStshfOrig         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbStshfOrig()));
            buffer.Append(" (").Append(GetLcbStshfOrig()).Append(" )\n");

            buffer.Append("    .fcStshf              = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcStshf()));
            buffer.Append(" (").Append(GetFcStshf()).Append(" )\n");

            buffer.Append("    .lcbStshf             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbStshf()));
            buffer.Append(" (").Append(GetLcbStshf()).Append(" )\n");

            buffer.Append("    .fcPlcffndRef         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffndRef()));
            buffer.Append(" (").Append(GetFcPlcffndRef()).Append(" )\n");

            buffer.Append("    .lcbPlcffndRef        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffndRef()));
            buffer.Append(" (").Append(GetLcbPlcffndRef()).Append(" )\n");

            buffer.Append("    .fcPlcffndTxt         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffndTxt()));
            buffer.Append(" (").Append(GetFcPlcffndTxt()).Append(" )\n");

            buffer.Append("    .lcbPlcffndTxt        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffndTxt()));
            buffer.Append(" (").Append(GetLcbPlcffndTxt()).Append(" )\n");

            buffer.Append("    .fcPlcfandRef         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfandRef()));
            buffer.Append(" (").Append(GetFcPlcfandRef()).Append(" )\n");

            buffer.Append("    .lcbPlcfandRef        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfandRef()));
            buffer.Append(" (").Append(GetLcbPlcfandRef()).Append(" )\n");

            buffer.Append("    .fcPlcfandTxt         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfandTxt()));
            buffer.Append(" (").Append(GetFcPlcfandTxt()).Append(" )\n");

            buffer.Append("    .lcbPlcfandTxt        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfandTxt()));
            buffer.Append(" (").Append(GetLcbPlcfandTxt()).Append(" )\n");

            buffer.Append("    .fcPlcfsed            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfsed()));
            buffer.Append(" (").Append(GetFcPlcfsed()).Append(" )\n");

            buffer.Append("    .lcbPlcfsed           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfsed()));
            buffer.Append(" (").Append(GetLcbPlcfsed()).Append(" )\n");

            buffer.Append("    .fcPlcpad             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcpad()));
            buffer.Append(" (").Append(GetFcPlcpad()).Append(" )\n");

            buffer.Append("    .lcbPlcpad            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcpad()));
            buffer.Append(" (").Append(GetLcbPlcpad()).Append(" )\n");

            buffer.Append("    .fcPlcfphe            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfphe()));
            buffer.Append(" (").Append(GetFcPlcfphe()).Append(" )\n");

            buffer.Append("    .lcbPlcfphe           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfphe()));
            buffer.Append(" (").Append(GetLcbPlcfphe()).Append(" )\n");

            buffer.Append("    .fcSttbfglsy          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfglsy()));
            buffer.Append(" (").Append(GetFcSttbfglsy()).Append(" )\n");

            buffer.Append("    .lcbSttbfglsy         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfglsy()));
            buffer.Append(" (").Append(GetLcbSttbfglsy()).Append(" )\n");

            buffer.Append("    .fcPlcfglsy           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfglsy()));
            buffer.Append(" (").Append(GetFcPlcfglsy()).Append(" )\n");

            buffer.Append("    .lcbPlcfglsy          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfglsy()));
            buffer.Append(" (").Append(GetLcbPlcfglsy()).Append(" )\n");

            buffer.Append("    .fcPlcfhdd            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfhdd()));
            buffer.Append(" (").Append(GetFcPlcfhdd()).Append(" )\n");

            buffer.Append("    .lcbPlcfhdd           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfhdd()));
            buffer.Append(" (").Append(GetLcbPlcfhdd()).Append(" )\n");

            buffer.Append("    .fcPlcfbteChpx        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfbteChpx()));
            buffer.Append(" (").Append(GetFcPlcfbteChpx()).Append(" )\n");

            buffer.Append("    .lcbPlcfbteChpx       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfbteChpx()));
            buffer.Append(" (").Append(GetLcbPlcfbteChpx()).Append(" )\n");

            buffer.Append("    .fcPlcfbtePapx        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfbtePapx()));
            buffer.Append(" (").Append(GetFcPlcfbtePapx()).Append(" )\n");

            buffer.Append("    .lcbPlcfbtePapx       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfbtePapx()));
            buffer.Append(" (").Append(GetLcbPlcfbtePapx()).Append(" )\n");

            buffer.Append("    .fcPlcfsea            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfsea()));
            buffer.Append(" (").Append(GetFcPlcfsea()).Append(" )\n");

            buffer.Append("    .lcbPlcfsea           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfsea()));
            buffer.Append(" (").Append(GetLcbPlcfsea()).Append(" )\n");

            buffer.Append("    .fcSttbfffn           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfffn()));
            buffer.Append(" (").Append(GetFcSttbfffn()).Append(" )\n");

            buffer.Append("    .lcbSttbfffn          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfffn()));
            buffer.Append(" (").Append(GetLcbSttbfffn()).Append(" )\n");

            buffer.Append("    .fcPlcffldMom         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldMom()));
            buffer.Append(" (").Append(GetFcPlcffldMom()).Append(" )\n");

            buffer.Append("    .lcbPlcffldMom        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldMom()));
            buffer.Append(" (").Append(GetLcbPlcffldMom()).Append(" )\n");

            buffer.Append("    .fcPlcffldHdr         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldHdr()));
            buffer.Append(" (").Append(GetFcPlcffldHdr()).Append(" )\n");

            buffer.Append("    .lcbPlcffldHdr        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldHdr()));
            buffer.Append(" (").Append(GetLcbPlcffldHdr()).Append(" )\n");

            buffer.Append("    .fcPlcffldFtn         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldFtn()));
            buffer.Append(" (").Append(GetFcPlcffldFtn()).Append(" )\n");

            buffer.Append("    .lcbPlcffldFtn        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldFtn()));
            buffer.Append(" (").Append(GetLcbPlcffldFtn()).Append(" )\n");

            buffer.Append("    .fcPlcffldAtn         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldAtn()));
            buffer.Append(" (").Append(GetFcPlcffldAtn()).Append(" )\n");

            buffer.Append("    .lcbPlcffldAtn        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldAtn()));
            buffer.Append(" (").Append(GetLcbPlcffldAtn()).Append(" )\n");

            buffer.Append("    .fcPlcffldMcr         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldMcr()));
            buffer.Append(" (").Append(GetFcPlcffldMcr()).Append(" )\n");

            buffer.Append("    .lcbPlcffldMcr        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldMcr()));
            buffer.Append(" (").Append(GetLcbPlcffldMcr()).Append(" )\n");

            buffer.Append("    .fcSttbfbkmk          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfbkmk()));
            buffer.Append(" (").Append(GetFcSttbfbkmk()).Append(" )\n");

            buffer.Append("    .lcbSttbfbkmk         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfbkmk()));
            buffer.Append(" (").Append(GetLcbSttbfbkmk()).Append(" )\n");

            buffer.Append("    .fcPlcfbkf            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfbkf()));
            buffer.Append(" (").Append(GetFcPlcfbkf()).Append(" )\n");

            buffer.Append("    .lcbPlcfbkf           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfbkf()));
            buffer.Append(" (").Append(GetLcbPlcfbkf()).Append(" )\n");

            buffer.Append("    .fcPlcfbkl            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfbkl()));
            buffer.Append(" (").Append(GetFcPlcfbkl()).Append(" )\n");

            buffer.Append("    .lcbPlcfbkl           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfbkl()));
            buffer.Append(" (").Append(GetLcbPlcfbkl()).Append(" )\n");

            buffer.Append("    .fcCmds               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcCmds()));
            buffer.Append(" (").Append(GetFcCmds()).Append(" )\n");

            buffer.Append("    .lcbCmds              = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbCmds()));
            buffer.Append(" (").Append(GetLcbCmds()).Append(" )\n");

            buffer.Append("    .fcPlcmcr             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcmcr()));
            buffer.Append(" (").Append(GetFcPlcmcr()).Append(" )\n");

            buffer.Append("    .lcbPlcmcr            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcmcr()));
            buffer.Append(" (").Append(GetLcbPlcmcr()).Append(" )\n");

            buffer.Append("    .fcSttbfmcr           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfmcr()));
            buffer.Append(" (").Append(GetFcSttbfmcr()).Append(" )\n");

            buffer.Append("    .lcbSttbfmcr          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfmcr()));
            buffer.Append(" (").Append(GetLcbSttbfmcr()).Append(" )\n");

            buffer.Append("    .fcPrDrvr             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPrDrvr()));
            buffer.Append(" (").Append(GetFcPrDrvr()).Append(" )\n");

            buffer.Append("    .lcbPrDrvr            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPrDrvr()));
            buffer.Append(" (").Append(GetLcbPrDrvr()).Append(" )\n");

            buffer.Append("    .fcPrEnvPort          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPrEnvPort()));
            buffer.Append(" (").Append(GetFcPrEnvPort()).Append(" )\n");

            buffer.Append("    .lcbPrEnvPort         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPrEnvPort()));
            buffer.Append(" (").Append(GetLcbPrEnvPort()).Append(" )\n");

            buffer.Append("    .fcPrEnvLand          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPrEnvLand()));
            buffer.Append(" (").Append(GetFcPrEnvLand()).Append(" )\n");

            buffer.Append("    .lcbPrEnvLand         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPrEnvLand()));
            buffer.Append(" (").Append(GetLcbPrEnvLand()).Append(" )\n");

            buffer.Append("    .fcWss                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcWss()));
            buffer.Append(" (").Append(GetFcWss()).Append(" )\n");

            buffer.Append("    .lcbWss               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbWss()));
            buffer.Append(" (").Append(GetLcbWss()).Append(" )\n");

            buffer.Append("    .fcDop                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcDop()));
            buffer.Append(" (").Append(GetFcDop()).Append(" )\n");

            buffer.Append("    .lcbDop               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbDop()));
            buffer.Append(" (").Append(GetLcbDop()).Append(" )\n");

            buffer.Append("    .fcSttbfAssoc         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfAssoc()));
            buffer.Append(" (").Append(GetFcSttbfAssoc()).Append(" )\n");

            buffer.Append("    .lcbSttbfAssoc        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfAssoc()));
            buffer.Append(" (").Append(GetLcbSttbfAssoc()).Append(" )\n");

            buffer.Append("    .fcClx                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcClx()));
            buffer.Append(" (").Append(GetFcClx()).Append(" )\n");

            buffer.Append("    .lcbClx               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbClx()));
            buffer.Append(" (").Append(GetLcbClx()).Append(" )\n");

            buffer.Append("    .fcPlcfpgdFtn         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfpgdFtn()));
            buffer.Append(" (").Append(GetFcPlcfpgdFtn()).Append(" )\n");

            buffer.Append("    .lcbPlcfpgdFtn        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfpgdFtn()));
            buffer.Append(" (").Append(GetLcbPlcfpgdFtn()).Append(" )\n");

            buffer.Append("    .fcAutosaveSource     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcAutosaveSource()));
            buffer.Append(" (").Append(GetFcAutosaveSource()).Append(" )\n");

            buffer.Append("    .lcbAutosaveSource    = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbAutosaveSource()));
            buffer.Append(" (").Append(GetLcbAutosaveSource()).Append(" )\n");

            buffer.Append("    .fcGrpXstAtnOwners    = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcGrpXstAtnOwners()));
            buffer.Append(" (").Append(GetFcGrpXstAtnOwners()).Append(" )\n");

            buffer.Append("    .lcbGrpXstAtnOwners   = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbGrpXstAtnOwners()));
            buffer.Append(" (").Append(GetLcbGrpXstAtnOwners()).Append(" )\n");

            buffer.Append("    .fcSttbfAtnbkmk       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfAtnbkmk()));
            buffer.Append(" (").Append(GetFcSttbfAtnbkmk()).Append(" )\n");

            buffer.Append("    .lcbSttbfAtnbkmk      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfAtnbkmk()));
            buffer.Append(" (").Append(GetLcbSttbfAtnbkmk()).Append(" )\n");

            buffer.Append("    .fcPlcdoaMom          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcdoaMom()));
            buffer.Append(" (").Append(GetFcPlcdoaMom()).Append(" )\n");

            buffer.Append("    .lcbPlcdoaMom         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcdoaMom()));
            buffer.Append(" (").Append(GetLcbPlcdoaMom()).Append(" )\n");

            buffer.Append("    .fcPlcdoaHdr          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcdoaHdr()));
            buffer.Append(" (").Append(GetFcPlcdoaHdr()).Append(" )\n");

            buffer.Append("    .lcbPlcdoaHdr         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcdoaHdr()));
            buffer.Append(" (").Append(GetLcbPlcdoaHdr()).Append(" )\n");

            buffer.Append("    .fcPlcspaMom          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcspaMom()));
            buffer.Append(" (").Append(GetFcPlcspaMom()).Append(" )\n");

            buffer.Append("    .lcbPlcspaMom         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcspaMom()));
            buffer.Append(" (").Append(GetLcbPlcspaMom()).Append(" )\n");

            buffer.Append("    .fcPlcspaHdr          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcspaHdr()));
            buffer.Append(" (").Append(GetFcPlcspaHdr()).Append(" )\n");

            buffer.Append("    .lcbPlcspaHdr         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcspaHdr()));
            buffer.Append(" (").Append(GetLcbPlcspaHdr()).Append(" )\n");

            buffer.Append("    .fcPlcfAtnbkf         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfAtnbkf()));
            buffer.Append(" (").Append(GetFcPlcfAtnbkf()).Append(" )\n");

            buffer.Append("    .lcbPlcfAtnbkf        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfAtnbkf()));
            buffer.Append(" (").Append(GetLcbPlcfAtnbkf()).Append(" )\n");

            buffer.Append("    .fcPlcfAtnbkl         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfAtnbkl()));
            buffer.Append(" (").Append(GetFcPlcfAtnbkl()).Append(" )\n");

            buffer.Append("    .lcbPlcfAtnbkl        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfAtnbkl()));
            buffer.Append(" (").Append(GetLcbPlcfAtnbkl()).Append(" )\n");

            buffer.Append("    .fcPms                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPms()));
            buffer.Append(" (").Append(GetFcPms()).Append(" )\n");

            buffer.Append("    .lcbPms               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPms()));
            buffer.Append(" (").Append(GetLcbPms()).Append(" )\n");

            buffer.Append("    .fcFormFldSttbs       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcFormFldSttbs()));
            buffer.Append(" (").Append(GetFcFormFldSttbs()).Append(" )\n");

            buffer.Append("    .lcbFormFldSttbs      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbFormFldSttbs()));
            buffer.Append(" (").Append(GetLcbFormFldSttbs()).Append(" )\n");

            buffer.Append("    .fcPlcfendRef         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfendRef()));
            buffer.Append(" (").Append(GetFcPlcfendRef()).Append(" )\n");

            buffer.Append("    .lcbPlcfendRef        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfendRef()));
            buffer.Append(" (").Append(GetLcbPlcfendRef()).Append(" )\n");

            buffer.Append("    .fcPlcfendTxt         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfendTxt()));
            buffer.Append(" (").Append(GetFcPlcfendTxt()).Append(" )\n");

            buffer.Append("    .lcbPlcfendTxt        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfendTxt()));
            buffer.Append(" (").Append(GetLcbPlcfendTxt()).Append(" )\n");

            buffer.Append("    .fcPlcffldEdn         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldEdn()));
            buffer.Append(" (").Append(GetFcPlcffldEdn()).Append(" )\n");

            buffer.Append("    .lcbPlcffldEdn        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldEdn()));
            buffer.Append(" (").Append(GetLcbPlcffldEdn()).Append(" )\n");

            buffer.Append("    .fcPlcfpgdEdn         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfpgdEdn()));
            buffer.Append(" (").Append(GetFcPlcfpgdEdn()).Append(" )\n");

            buffer.Append("    .lcbPlcfpgdEdn        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfpgdEdn()));
            buffer.Append(" (").Append(GetLcbPlcfpgdEdn()).Append(" )\n");

            buffer.Append("    .fcDggInfo            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcDggInfo()));
            buffer.Append(" (").Append(GetFcDggInfo()).Append(" )\n");

            buffer.Append("    .lcbDggInfo           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbDggInfo()));
            buffer.Append(" (").Append(GetLcbDggInfo()).Append(" )\n");

            buffer.Append("    .fcSttbfRMark         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfRMark()));
            buffer.Append(" (").Append(GetFcSttbfRMark()).Append(" )\n");

            buffer.Append("    .lcbSttbfRMark        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfRMark()));
            buffer.Append(" (").Append(GetLcbSttbfRMark()).Append(" )\n");

            buffer.Append("    .fcSttbCaption        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbCaption()));
            buffer.Append(" (").Append(GetFcSttbCaption()).Append(" )\n");

            buffer.Append("    .lcbSttbCaption       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbCaption()));
            buffer.Append(" (").Append(GetLcbSttbCaption()).Append(" )\n");

            buffer.Append("    .fcSttbAutoCaption    = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbAutoCaption()));
            buffer.Append(" (").Append(GetFcSttbAutoCaption()).Append(" )\n");

            buffer.Append("    .lcbSttbAutoCaption   = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbAutoCaption()));
            buffer.Append(" (").Append(GetLcbSttbAutoCaption()).Append(" )\n");

            buffer.Append("    .fcPlcfwkb            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfwkb()));
            buffer.Append(" (").Append(GetFcPlcfwkb()).Append(" )\n");

            buffer.Append("    .lcbPlcfwkb           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfwkb()));
            buffer.Append(" (").Append(GetLcbPlcfwkb()).Append(" )\n");

            buffer.Append("    .fcPlcfspl            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfspl()));
            buffer.Append(" (").Append(GetFcPlcfspl()).Append(" )\n");

            buffer.Append("    .lcbPlcfspl           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfspl()));
            buffer.Append(" (").Append(GetLcbPlcfspl()).Append(" )\n");

            buffer.Append("    .fcPlcftxbxTxt        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcftxbxTxt()));
            buffer.Append(" (").Append(GetFcPlcftxbxTxt()).Append(" )\n");

            buffer.Append("    .lcbPlcftxbxTxt       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcftxbxTxt()));
            buffer.Append(" (").Append(GetLcbPlcftxbxTxt()).Append(" )\n");

            buffer.Append("    .fcPlcffldTxbx        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldTxbx()));
            buffer.Append(" (").Append(GetFcPlcffldTxbx()).Append(" )\n");

            buffer.Append("    .lcbPlcffldTxbx       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldTxbx()));
            buffer.Append(" (").Append(GetLcbPlcffldTxbx()).Append(" )\n");

            buffer.Append("    .fcPlcfhdrtxbxTxt     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfhdrtxbxTxt()));
            buffer.Append(" (").Append(GetFcPlcfhdrtxbxTxt()).Append(" )\n");

            buffer.Append("    .lcbPlcfhdrtxbxTxt    = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfhdrtxbxTxt()));
            buffer.Append(" (").Append(GetLcbPlcfhdrtxbxTxt()).Append(" )\n");

            buffer.Append("    .fcPlcffldHdrTxbx     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcffldHdrTxbx()));
            buffer.Append(" (").Append(GetFcPlcffldHdrTxbx()).Append(" )\n");

            buffer.Append("    .lcbPlcffldHdrTxbx    = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcffldHdrTxbx()));
            buffer.Append(" (").Append(GetLcbPlcffldHdrTxbx()).Append(" )\n");

            buffer.Append("    .fcStwUser            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcStwUser()));
            buffer.Append(" (").Append(GetFcStwUser()).Append(" )\n");

            buffer.Append("    .lcbStwUser           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbStwUser()));
            buffer.Append(" (").Append(GetLcbStwUser()).Append(" )\n");

            buffer.Append("    .fcSttbttmbd          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbttmbd()));
            buffer.Append(" (").Append(GetFcSttbttmbd()).Append(" )\n");

            buffer.Append("    .cbSttbttmbd          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetCbSttbttmbd()));
            buffer.Append(" (").Append(GetCbSttbttmbd()).Append(" )\n");

            buffer.Append("    .fcUnused             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcUnused()));
            buffer.Append(" (").Append(GetFcUnused()).Append(" )\n");

            buffer.Append("    .lcbUnused            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbUnused()));
            buffer.Append(" (").Append(GetLcbUnused()).Append(" )\n");

            buffer.Append("    .fcPgdMother          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPgdMother()));
            buffer.Append(" (").Append(GetFcPgdMother()).Append(" )\n");

            buffer.Append("    .lcbPgdMother         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPgdMother()));
            buffer.Append(" (").Append(GetLcbPgdMother()).Append(" )\n");

            buffer.Append("    .fcBkdMother          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcBkdMother()));
            buffer.Append(" (").Append(GetFcBkdMother()).Append(" )\n");

            buffer.Append("    .lcbBkdMother         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbBkdMother()));
            buffer.Append(" (").Append(GetLcbBkdMother()).Append(" )\n");

            buffer.Append("    .fcPgdFtn             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPgdFtn()));
            buffer.Append(" (").Append(GetFcPgdFtn()).Append(" )\n");

            buffer.Append("    .lcbPgdFtn            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPgdFtn()));
            buffer.Append(" (").Append(GetLcbPgdFtn()).Append(" )\n");

            buffer.Append("    .fcBkdFtn             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcBkdFtn()));
            buffer.Append(" (").Append(GetFcBkdFtn()).Append(" )\n");

            buffer.Append("    .lcbBkdFtn            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbBkdFtn()));
            buffer.Append(" (").Append(GetLcbBkdFtn()).Append(" )\n");

            buffer.Append("    .fcPgdEdn             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPgdEdn()));
            buffer.Append(" (").Append(GetFcPgdEdn()).Append(" )\n");

            buffer.Append("    .lcbPgdEdn            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPgdEdn()));
            buffer.Append(" (").Append(GetLcbPgdEdn()).Append(" )\n");

            buffer.Append("    .fcBkdEdn             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcBkdEdn()));
            buffer.Append(" (").Append(GetFcBkdEdn()).Append(" )\n");

            buffer.Append("    .lcbBkdEdn            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbBkdEdn()));
            buffer.Append(" (").Append(GetLcbBkdEdn()).Append(" )\n");

            buffer.Append("    .fcSttbfIntlFld       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfIntlFld()));
            buffer.Append(" (").Append(GetFcSttbfIntlFld()).Append(" )\n");

            buffer.Append("    .lcbSttbfIntlFld      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfIntlFld()));
            buffer.Append(" (").Append(GetLcbSttbfIntlFld()).Append(" )\n");

            buffer.Append("    .fcRouteSlip          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcRouteSlip()));
            buffer.Append(" (").Append(GetFcRouteSlip()).Append(" )\n");

            buffer.Append("    .lcbRouteSlip         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbRouteSlip()));
            buffer.Append(" (").Append(GetLcbRouteSlip()).Append(" )\n");

            buffer.Append("    .fcSttbSavedBy        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbSavedBy()));
            buffer.Append(" (").Append(GetFcSttbSavedBy()).Append(" )\n");

            buffer.Append("    .lcbSttbSavedBy       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbSavedBy()));
            buffer.Append(" (").Append(GetLcbSttbSavedBy()).Append(" )\n");

            buffer.Append("    .fcSttbFnm            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbFnm()));
            buffer.Append(" (").Append(GetFcSttbFnm()).Append(" )\n");

            buffer.Append("    .lcbSttbFnm           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbFnm()));
            buffer.Append(" (").Append(GetLcbSttbFnm()).Append(" )\n");

            buffer.Append("    .fcPlcfLst            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfLst()));
            buffer.Append(" (").Append(GetFcPlcfLst()).Append(" )\n");

            buffer.Append("    .lcbPlcfLst           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfLst()));
            buffer.Append(" (").Append(GetLcbPlcfLst()).Append(" )\n");

            buffer.Append("    .fcPlfLfo             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlfLfo()));
            buffer.Append(" (").Append(GetFcPlfLfo()).Append(" )\n");

            buffer.Append("    .lcbPlfLfo            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlfLfo()));
            buffer.Append(" (").Append(GetLcbPlfLfo()).Append(" )\n");

            buffer.Append("    .fcPlcftxbxBkd        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcftxbxBkd()));
            buffer.Append(" (").Append(GetFcPlcftxbxBkd()).Append(" )\n");

            buffer.Append("    .lcbPlcftxbxBkd       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcftxbxBkd()));
            buffer.Append(" (").Append(GetLcbPlcftxbxBkd()).Append(" )\n");

            buffer.Append("    .fcPlcftxbxHdrBkd     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcftxbxHdrBkd()));
            buffer.Append(" (").Append(GetFcPlcftxbxHdrBkd()).Append(" )\n");

            buffer.Append("    .lcbPlcftxbxHdrBkd    = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcftxbxHdrBkd()));
            buffer.Append(" (").Append(GetLcbPlcftxbxHdrBkd()).Append(" )\n");

            buffer.Append("    .fcDocUndo            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcDocUndo()));
            buffer.Append(" (").Append(GetFcDocUndo()).Append(" )\n");

            buffer.Append("    .lcbDocUndo           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbDocUndo()));
            buffer.Append(" (").Append(GetLcbDocUndo()).Append(" )\n");

            buffer.Append("    .fcRgbuse             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcRgbuse()));
            buffer.Append(" (").Append(GetFcRgbuse()).Append(" )\n");

            buffer.Append("    .lcbRgbuse            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbRgbuse()));
            buffer.Append(" (").Append(GetLcbRgbuse()).Append(" )\n");

            buffer.Append("    .fcUsp                = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcUsp()));
            buffer.Append(" (").Append(GetFcUsp()).Append(" )\n");

            buffer.Append("    .lcbUsp               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbUsp()));
            buffer.Append(" (").Append(GetLcbUsp()).Append(" )\n");

            buffer.Append("    .fcUskf               = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcUskf()));
            buffer.Append(" (").Append(GetFcUskf()).Append(" )\n");

            buffer.Append("    .lcbUskf              = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbUskf()));
            buffer.Append(" (").Append(GetLcbUskf()).Append(" )\n");

            buffer.Append("    .fcPlcupcRgbuse       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcupcRgbuse()));
            buffer.Append(" (").Append(GetFcPlcupcRgbuse()).Append(" )\n");

            buffer.Append("    .lcbPlcupcRgbuse      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcupcRgbuse()));
            buffer.Append(" (").Append(GetLcbPlcupcRgbuse()).Append(" )\n");

            buffer.Append("    .fcPlcupcUsp          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcupcUsp()));
            buffer.Append(" (").Append(GetFcPlcupcUsp()).Append(" )\n");

            buffer.Append("    .lcbPlcupcUsp         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcupcUsp()));
            buffer.Append(" (").Append(GetLcbPlcupcUsp()).Append(" )\n");

            buffer.Append("    .fcSttbGlsyStyle      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbGlsyStyle()));
            buffer.Append(" (").Append(GetFcSttbGlsyStyle()).Append(" )\n");

            buffer.Append("    .lcbSttbGlsyStyle     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbGlsyStyle()));
            buffer.Append(" (").Append(GetLcbSttbGlsyStyle()).Append(" )\n");

            buffer.Append("    .fcPlgosl             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlgosl()));
            buffer.Append(" (").Append(GetFcPlgosl()).Append(" )\n");

            buffer.Append("    .lcbPlgosl            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlgosl()));
            buffer.Append(" (").Append(GetLcbPlgosl()).Append(" )\n");

            buffer.Append("    .fcPlcocx             = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcocx()));
            buffer.Append(" (").Append(GetFcPlcocx()).Append(" )\n");

            buffer.Append("    .lcbPlcocx            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcocx()));
            buffer.Append(" (").Append(GetLcbPlcocx()).Append(" )\n");

            buffer.Append("    .fcPlcfbteLvc         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfbteLvc()));
            buffer.Append(" (").Append(GetFcPlcfbteLvc()).Append(" )\n");

            buffer.Append("    .lcbPlcfbteLvc        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfbteLvc()));
            buffer.Append(" (").Append(GetLcbPlcfbteLvc()).Append(" )\n");

            buffer.Append("    .dwLowDateTime        = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetDwLowDateTime()));
            buffer.Append(" (").Append(GetDwLowDateTime()).Append(" )\n");

            buffer.Append("    .dwHighDateTime       = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetDwHighDateTime()));
            buffer.Append(" (").Append(GetDwHighDateTime()).Append(" )\n");

            buffer.Append("    .fcPlcflvc            = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcflvc()));
            buffer.Append(" (").Append(GetFcPlcflvc()).Append(" )\n");

            buffer.Append("    .lcbPlcflvc           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcflvc()));
            buffer.Append(" (").Append(GetLcbPlcflvc()).Append(" )\n");

            buffer.Append("    .fcPlcasumy           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcasumy()));
            buffer.Append(" (").Append(GetFcPlcasumy()).Append(" )\n");

            buffer.Append("    .lcbPlcasumy          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcasumy()));
            buffer.Append(" (").Append(GetLcbPlcasumy()).Append(" )\n");

            buffer.Append("    .fcPlcfgram           = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcPlcfgram()));
            buffer.Append(" (").Append(GetFcPlcfgram()).Append(" )\n");

            buffer.Append("    .lcbPlcfgram          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbPlcfgram()));
            buffer.Append(" (").Append(GetLcbPlcfgram()).Append(" )\n");

            buffer.Append("    .fcSttbListNames      = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbListNames()));
            buffer.Append(" (").Append(GetFcSttbListNames()).Append(" )\n");

            buffer.Append("    .lcbSttbListNames     = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbListNames()));
            buffer.Append(" (").Append(GetLcbSttbListNames()).Append(" )\n");

            buffer.Append("    .fcSttbfUssr          = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetFcSttbfUssr()));
            buffer.Append(" (").Append(GetFcSttbfUssr()).Append(" )\n");

            buffer.Append("    .lcbSttbfUssr         = ");
            buffer.Append("0x");
            buffer.Append(HexDump.ToHex((int)GetLcbSttbfUssr()));
            buffer.Append(" (").Append(GetLcbSttbfUssr()).Append(" )\n");

            buffer.Append("[/FIB]\n");
            return buffer.ToString();
        }

        /**
         * Size of record (exluding 4 byte header)
         */
        public int GetSize()
        {
            return 4 + +2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 4 + 4 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 2 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 2 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4;
        }



        /**
         * Get the wIdent field for the FIB record.
         */
        public int GetWIdent()
        {
            return field_1_wIdent;
        }

        /**
         * Set the wIdent field for the FIB record.
         */
        public void SetWIdent(int field_1_wIdent)
        {
            this.field_1_wIdent = field_1_wIdent;
        }

        /**
         * Get the nFib field for the FIB record.
         */
        public int GetNFib()
        {
            return field_2_nFib;
        }

        /**
         * Set the nFib field for the FIB record.
         */
        public void SetNFib(int field_2_nFib)
        {
            this.field_2_nFib = field_2_nFib;
        }

        /**
         * Get the nProduct field for the FIB record.
         */
        public int GetNProduct()
        {
            return field_3_nProduct;
        }

        /**
         * Set the nProduct field for the FIB record.
         */
        public void SetNProduct(int field_3_nProduct)
        {
            this.field_3_nProduct = field_3_nProduct;
        }

        /**
         * Get the lid field for the FIB record.
         */
        public int GetLid()
        {
            return field_4_lid;
        }

        /**
         * Set the lid field for the FIB record.
         */
        public void SetLid(int field_4_lid)
        {
            this.field_4_lid = field_4_lid;
        }

        /**
         * Get the pnNext field for the FIB record.
         */
        public int GetPnNext()
        {
            return field_5_pnNext;
        }

        /**
         * Set the pnNext field for the FIB record.
         */
        public void SetPnNext(int field_5_pnNext)
        {
            this.field_5_pnNext = field_5_pnNext;
        }

        /**
         * Get the options field for the FIB record.
         */
        public short GetOptions()
        {
            return field_6_options;
        }

        /**
         * Set the options field for the FIB record.
         */
        public void SetOptions(short field_6_options)
        {
            this.field_6_options = field_6_options;
        }

        /**
         * Get the nFibBack field for the FIB record.
         */
        public int GetNFibBack()
        {
            return field_7_nFibBack;
        }

        /**
         * Set the nFibBack field for the FIB record.
         */
        public void SetNFibBack(int field_7_nFibBack)
        {
            this.field_7_nFibBack = field_7_nFibBack;
        }

        /**
         * Get the lKey field for the FIB record.
         */
        public int GetLKey()
        {
            return field_8_lKey;
        }

        /**
         * Set the lKey field for the FIB record.
         */
        public void SetLKey(int field_8_lKey)
        {
            this.field_8_lKey = field_8_lKey;
        }

        /**
         * Get the envr field for the FIB record.
         */
        public int GetEnvr()
        {
            return field_9_envr;
        }

        /**
         * Set the envr field for the FIB record.
         */
        public void SetEnvr(int field_9_envr)
        {
            this.field_9_envr = field_9_envr;
        }

        /**
         * Get the history field for the FIB record.
         */
        public short GetHistory()
        {
            return field_10_history;
        }

        /**
         * Set the history field for the FIB record.
         */
        public void SetHistory(short field_10_history)
        {
            this.field_10_history = field_10_history;
        }

        /**
         * Get the chs field for the FIB record.
         */
        public int GetChs()
        {
            return field_11_chs;
        }

        /**
         * Set the chs field for the FIB record.
         */
        public void SetChs(int field_11_chs)
        {
            this.field_11_chs = field_11_chs;
        }

        /**
         * Get the chsTables field for the FIB record.
         */
        public int GetChsTables()
        {
            return field_12_chsTables;
        }

        /**
         * Set the chsTables field for the FIB record.
         */
        public void SetChsTables(int field_12_chsTables)
        {
            this.field_12_chsTables = field_12_chsTables;
        }

        /**
         * Get the fcMin field for the FIB record.
         */
        public int GetFcMin()
        {
            return field_13_fcMin;
        }

        /**
         * Set the fcMin field for the FIB record.
         */
        public void SetFcMin(int field_13_fcMin)
        {
            this.field_13_fcMin = field_13_fcMin;
        }

        /**
         * Get the fcMac field for the FIB record.
         */
        public int GetFcMac()
        {
            return field_14_fcMac;
        }

        /**
         * Set the fcMac field for the FIB record.
         */
        public void SetFcMac(int field_14_fcMac)
        {
            this.field_14_fcMac = field_14_fcMac;
        }

        /**
         * Get the csw field for the FIB record.
         */
        public int GetCsw()
        {
            return field_15_csw;
        }

        /**
         * Set the csw field for the FIB record.
         */
        public void SetCsw(int field_15_csw)
        {
            this.field_15_csw = field_15_csw;
        }

        /**
         * Get the wMagicCreated field for the FIB record.
         */
        public int GetWMagicCreated()
        {
            return field_16_wMagicCreated;
        }

        /**
         * Set the wMagicCreated field for the FIB record.
         */
        public void SetWMagicCreated(int field_16_wMagicCreated)
        {
            this.field_16_wMagicCreated = field_16_wMagicCreated;
        }

        /**
         * Get the wMagicRevised field for the FIB record.
         */
        public int GetWMagicRevised()
        {
            return field_17_wMagicRevised;
        }

        /**
         * Set the wMagicRevised field for the FIB record.
         */
        public void SetWMagicRevised(int field_17_wMagicRevised)
        {
            this.field_17_wMagicRevised = field_17_wMagicRevised;
        }

        /**
         * Get the wMagicCreatedPrivate field for the FIB record.
         */
        public int GetWMagicCreatedPrivate()
        {
            return field_18_wMagicCreatedPrivate;
        }

        /**
         * Set the wMagicCreatedPrivate field for the FIB record.
         */
        public void SetWMagicCreatedPrivate(int field_18_wMagicCreatedPrivate)
        {
            this.field_18_wMagicCreatedPrivate = field_18_wMagicCreatedPrivate;
        }

        /**
         * Get the wMagicRevisedPrivate field for the FIB record.
         */
        public int GetWMagicRevisedPrivate()
        {
            return field_19_wMagicRevisedPrivate;
        }

        /**
         * Set the wMagicRevisedPrivate field for the FIB record.
         */
        public void SetWMagicRevisedPrivate(int field_19_wMagicRevisedPrivate)
        {
            this.field_19_wMagicRevisedPrivate = field_19_wMagicRevisedPrivate;
        }

        /**
         * Get the pnFbpChpFirst_W6 field for the FIB record.
         */
        public int GetPnFbpChpFirst_W6()
        {
            return field_20_pnFbpChpFirst_W6;
        }

        /**
         * Set the pnFbpChpFirst_W6 field for the FIB record.
         */
        public void SetPnFbpChpFirst_W6(int field_20_pnFbpChpFirst_W6)
        {
            this.field_20_pnFbpChpFirst_W6 = field_20_pnFbpChpFirst_W6;
        }

        /**
         * Get the pnChpFirst_W6 field for the FIB record.
         */
        public int GetPnChpFirst_W6()
        {
            return field_21_pnChpFirst_W6;
        }

        /**
         * Set the pnChpFirst_W6 field for the FIB record.
         */
        public void SetPnChpFirst_W6(int field_21_pnChpFirst_W6)
        {
            this.field_21_pnChpFirst_W6 = field_21_pnChpFirst_W6;
        }

        /**
         * Get the cpnBteChp_W6 field for the FIB record.
         */
        public int GetCpnBteChp_W6()
        {
            return field_22_cpnBteChp_W6;
        }

        /**
         * Set the cpnBteChp_W6 field for the FIB record.
         */
        public void SetCpnBteChp_W6(int field_22_cpnBteChp_W6)
        {
            this.field_22_cpnBteChp_W6 = field_22_cpnBteChp_W6;
        }

        /**
         * Get the pnFbpPapFirst_W6 field for the FIB record.
         */
        public int GetPnFbpPapFirst_W6()
        {
            return field_23_pnFbpPapFirst_W6;
        }

        /**
         * Set the pnFbpPapFirst_W6 field for the FIB record.
         */
        public void SetPnFbpPapFirst_W6(int field_23_pnFbpPapFirst_W6)
        {
            this.field_23_pnFbpPapFirst_W6 = field_23_pnFbpPapFirst_W6;
        }

        /**
         * Get the pnPapFirst_W6 field for the FIB record.
         */
        public int GetPnPapFirst_W6()
        {
            return field_24_pnPapFirst_W6;
        }

        /**
         * Set the pnPapFirst_W6 field for the FIB record.
         */
        public void SetPnPapFirst_W6(int field_24_pnPapFirst_W6)
        {
            this.field_24_pnPapFirst_W6 = field_24_pnPapFirst_W6;
        }

        /**
         * Get the cpnBtePap_W6 field for the FIB record.
         */
        public int GetCpnBtePap_W6()
        {
            return field_25_cpnBtePap_W6;
        }

        /**
         * Set the cpnBtePap_W6 field for the FIB record.
         */
        public void SetCpnBtePap_W6(int field_25_cpnBtePap_W6)
        {
            this.field_25_cpnBtePap_W6 = field_25_cpnBtePap_W6;
        }

        /**
         * Get the pnFbpLvcFirst_W6 field for the FIB record.
         */
        public int GetPnFbpLvcFirst_W6()
        {
            return field_26_pnFbpLvcFirst_W6;
        }

        /**
         * Set the pnFbpLvcFirst_W6 field for the FIB record.
         */
        public void SetPnFbpLvcFirst_W6(int field_26_pnFbpLvcFirst_W6)
        {
            this.field_26_pnFbpLvcFirst_W6 = field_26_pnFbpLvcFirst_W6;
        }

        /**
         * Get the pnLvcFirst_W6 field for the FIB record.
         */
        public int GetPnLvcFirst_W6()
        {
            return field_27_pnLvcFirst_W6;
        }

        /**
         * Set the pnLvcFirst_W6 field for the FIB record.
         */
        public void SetPnLvcFirst_W6(int field_27_pnLvcFirst_W6)
        {
            this.field_27_pnLvcFirst_W6 = field_27_pnLvcFirst_W6;
        }

        /**
         * Get the cpnBteLvc_W6 field for the FIB record.
         */
        public int GetCpnBteLvc_W6()
        {
            return field_28_cpnBteLvc_W6;
        }

        /**
         * Set the cpnBteLvc_W6 field for the FIB record.
         */
        public void SetCpnBteLvc_W6(int field_28_cpnBteLvc_W6)
        {
            this.field_28_cpnBteLvc_W6 = field_28_cpnBteLvc_W6;
        }

        /**
         * Get the lidFE field for the FIB record.
         */
        public int GetLidFE()
        {
            return field_29_lidFE;
        }

        /**
         * Set the lidFE field for the FIB record.
         */
        public void SetLidFE(int field_29_lidFE)
        {
            this.field_29_lidFE = field_29_lidFE;
        }

        /**
         * Get the clw field for the FIB record.
         */
        public int GetClw()
        {
            return field_30_clw;
        }

        /**
         * Set the clw field for the FIB record.
         */
        public void SetClw(int field_30_clw)
        {
            this.field_30_clw = field_30_clw;
        }

        /**
         * Get the cbMac field for the FIB record.
         */
        public int GetCbMac()
        {
            return field_31_cbMac;
        }

        /**
         * Set the cbMac field for the FIB record.
         */
        public void SetCbMac(int field_31_cbMac)
        {
            this.field_31_cbMac = field_31_cbMac;
        }

        /**
         * Get the lProductCreated field for the FIB record.
         */
        public int GetLProductCreated()
        {
            return field_32_lProductCreated;
        }

        /**
         * Set the lProductCreated field for the FIB record.
         */
        public void SetLProductCreated(int field_32_lProductCreated)
        {
            this.field_32_lProductCreated = field_32_lProductCreated;
        }

        /**
         * Get the lProductRevised field for the FIB record.
         */
        public int GetLProductRevised()
        {
            return field_33_lProductRevised;
        }

        /**
         * Set the lProductRevised field for the FIB record.
         */
        public void SetLProductRevised(int field_33_lProductRevised)
        {
            this.field_33_lProductRevised = field_33_lProductRevised;
        }

        /**
         * Get the ccpText field for the FIB record.
         */
        public int GetCcpText()
        {
            return field_34_ccpText;
        }

        /**
         * Set the ccpText field for the FIB record.
         */
        public void SetCcpText(int field_34_ccpText)
        {
            this.field_34_ccpText = field_34_ccpText;
        }

        /**
         * Get the ccpFtn field for the FIB record.
         */
        public int GetCcpFtn()
        {
            return field_35_ccpFtn;
        }

        /**
         * Set the ccpFtn field for the FIB record.
         */
        public void SetCcpFtn(int field_35_ccpFtn)
        {
            this.field_35_ccpFtn = field_35_ccpFtn;
        }

        /**
         * Get the ccpHdd field for the FIB record.
         */
        public int GetCcpHdd()
        {
            return field_36_ccpHdd;
        }

        /**
         * Set the ccpHdd field for the FIB record.
         */
        public void SetCcpHdd(int field_36_ccpHdd)
        {
            this.field_36_ccpHdd = field_36_ccpHdd;
        }

        /**
         * Get the ccpMcr field for the FIB record.
         */
        public int GetCcpMcr()
        {
            return field_37_ccpMcr;
        }

        /**
         * Set the ccpMcr field for the FIB record.
         */
        public void SetCcpMcr(int field_37_ccpMcr)
        {
            this.field_37_ccpMcr = field_37_ccpMcr;
        }

        /**
         * Get the ccpAtn field for the FIB record.
         */
        public int GetCcpAtn()
        {
            return field_38_ccpAtn;
        }

        /**
         * Set the ccpAtn field for the FIB record.
         */
        public void SetCcpAtn(int field_38_ccpAtn)
        {
            this.field_38_ccpAtn = field_38_ccpAtn;
        }

        /**
         * Get the ccpEdn field for the FIB record.
         */
        public int GetCcpEdn()
        {
            return field_39_ccpEdn;
        }

        /**
         * Set the ccpEdn field for the FIB record.
         */
        public void SetCcpEdn(int field_39_ccpEdn)
        {
            this.field_39_ccpEdn = field_39_ccpEdn;
        }

        /**
         * Get the ccpTxbx field for the FIB record.
         */
        public int GetCcpTxbx()
        {
            return field_40_ccpTxbx;
        }

        /**
         * Set the ccpTxbx field for the FIB record.
         */
        public void SetCcpTxbx(int field_40_ccpTxbx)
        {
            this.field_40_ccpTxbx = field_40_ccpTxbx;
        }

        /**
         * Get the ccpHdrTxbx field for the FIB record.
         */
        public int GetCcpHdrTxbx()
        {
            return field_41_ccpHdrTxbx;
        }

        /**
         * Set the ccpHdrTxbx field for the FIB record.
         */
        public void SetCcpHdrTxbx(int field_41_ccpHdrTxbx)
        {
            this.field_41_ccpHdrTxbx = field_41_ccpHdrTxbx;
        }

        /**
         * Get the pnFbpChpFirst field for the FIB record.
         */
        public int GetPnFbpChpFirst()
        {
            return field_42_pnFbpChpFirst;
        }

        /**
         * Set the pnFbpChpFirst field for the FIB record.
         */
        public void SetPnFbpChpFirst(int field_42_pnFbpChpFirst)
        {
            this.field_42_pnFbpChpFirst = field_42_pnFbpChpFirst;
        }

        /**
         * Get the pnChpFirst field for the FIB record.
         */
        public int GetPnChpFirst()
        {
            return field_43_pnChpFirst;
        }

        /**
         * Set the pnChpFirst field for the FIB record.
         */
        public void SetPnChpFirst(int field_43_pnChpFirst)
        {
            this.field_43_pnChpFirst = field_43_pnChpFirst;
        }

        /**
         * Get the cpnBteChp field for the FIB record.
         */
        public int GetCpnBteChp()
        {
            return field_44_cpnBteChp;
        }

        /**
         * Set the cpnBteChp field for the FIB record.
         */
        public void SetCpnBteChp(int field_44_cpnBteChp)
        {
            this.field_44_cpnBteChp = field_44_cpnBteChp;
        }

        /**
         * Get the pnFbpPapFirst field for the FIB record.
         */
        public int GetPnFbpPapFirst()
        {
            return field_45_pnFbpPapFirst;
        }

        /**
         * Set the pnFbpPapFirst field for the FIB record.
         */
        public void SetPnFbpPapFirst(int field_45_pnFbpPapFirst)
        {
            this.field_45_pnFbpPapFirst = field_45_pnFbpPapFirst;
        }

        /**
         * Get the pnPapFirst field for the FIB record.
         */
        public int GetPnPapFirst()
        {
            return field_46_pnPapFirst;
        }

        /**
         * Set the pnPapFirst field for the FIB record.
         */
        public void SetPnPapFirst(int field_46_pnPapFirst)
        {
            this.field_46_pnPapFirst = field_46_pnPapFirst;
        }

        /**
         * Get the cpnBtePap field for the FIB record.
         */
        public int GetCpnBtePap()
        {
            return field_47_cpnBtePap;
        }

        /**
         * Set the cpnBtePap field for the FIB record.
         */
        public void SetCpnBtePap(int field_47_cpnBtePap)
        {
            this.field_47_cpnBtePap = field_47_cpnBtePap;
        }

        /**
         * Get the pnFbpLvcFirst field for the FIB record.
         */
        public int GetPnFbpLvcFirst()
        {
            return field_48_pnFbpLvcFirst;
        }

        /**
         * Set the pnFbpLvcFirst field for the FIB record.
         */
        public void SetPnFbpLvcFirst(int field_48_pnFbpLvcFirst)
        {
            this.field_48_pnFbpLvcFirst = field_48_pnFbpLvcFirst;
        }

        /**
         * Get the pnLvcFirst field for the FIB record.
         */
        public int GetPnLvcFirst()
        {
            return field_49_pnLvcFirst;
        }

        /**
         * Set the pnLvcFirst field for the FIB record.
         */
        public void SetPnLvcFirst(int field_49_pnLvcFirst)
        {
            this.field_49_pnLvcFirst = field_49_pnLvcFirst;
        }

        /**
         * Get the cpnBteLvc field for the FIB record.
         */
        public int GetCpnBteLvc()
        {
            return field_50_cpnBteLvc;
        }

        /**
         * Set the cpnBteLvc field for the FIB record.
         */
        public void SetCpnBteLvc(int field_50_cpnBteLvc)
        {
            this.field_50_cpnBteLvc = field_50_cpnBteLvc;
        }

        /**
         * Get the fcIslandFirst field for the FIB record.
         */
        public int GetFcIslandFirst()
        {
            return field_51_fcIslandFirst;
        }

        /**
         * Set the fcIslandFirst field for the FIB record.
         */
        public void SetFcIslandFirst(int field_51_fcIslandFirst)
        {
            this.field_51_fcIslandFirst = field_51_fcIslandFirst;
        }

        /**
         * Get the fcIslandLim field for the FIB record.
         */
        public int GetFcIslandLim()
        {
            return field_52_fcIslandLim;
        }

        /**
         * Set the fcIslandLim field for the FIB record.
         */
        public void SetFcIslandLim(int field_52_fcIslandLim)
        {
            this.field_52_fcIslandLim = field_52_fcIslandLim;
        }

        /**
         * Get the cfclcb field for the FIB record.
         */
        public int GetCfclcb()
        {
            return field_53_cfclcb;
        }

        /**
         * Set the cfclcb field for the FIB record.
         */
        public void SetCfclcb(int field_53_cfclcb)
        {
            this.field_53_cfclcb = field_53_cfclcb;
        }

        /**
         * Get the fcStshfOrig field for the FIB record.
         */
        public int GetFcStshfOrig()
        {
            return field_54_fcStshfOrig;
        }

        /**
         * Set the fcStshfOrig field for the FIB record.
         */
        public void SetFcStshfOrig(int field_54_fcStshfOrig)
        {
            this.field_54_fcStshfOrig = field_54_fcStshfOrig;
        }

        /**
         * Get the lcbStshfOrig field for the FIB record.
         */
        public int GetLcbStshfOrig()
        {
            return field_55_lcbStshfOrig;
        }

        /**
         * Set the lcbStshfOrig field for the FIB record.
         */
        public void SetLcbStshfOrig(int field_55_lcbStshfOrig)
        {
            this.field_55_lcbStshfOrig = field_55_lcbStshfOrig;
        }

        /**
         * Get the fcStshf field for the FIB record.
         */
        public int GetFcStshf()
        {
            return field_56_fcStshf;
        }

        /**
         * Set the fcStshf field for the FIB record.
         */
        public void SetFcStshf(int field_56_fcStshf)
        {
            this.field_56_fcStshf = field_56_fcStshf;
        }

        /**
         * Get the lcbStshf field for the FIB record.
         */
        public int GetLcbStshf()
        {
            return field_57_lcbStshf;
        }

        /**
         * Set the lcbStshf field for the FIB record.
         */
        public void SetLcbStshf(int field_57_lcbStshf)
        {
            this.field_57_lcbStshf = field_57_lcbStshf;
        }

        /**
         * Get the fcPlcffndRef field for the FIB record.
         */
        public int GetFcPlcffndRef()
        {
            return field_58_fcPlcffndRef;
        }

        /**
         * Set the fcPlcffndRef field for the FIB record.
         */
        public void SetFcPlcffndRef(int field_58_fcPlcffndRef)
        {
            this.field_58_fcPlcffndRef = field_58_fcPlcffndRef;
        }

        /**
         * Get the lcbPlcffndRef field for the FIB record.
         */
        public int GetLcbPlcffndRef()
        {
            return field_59_lcbPlcffndRef;
        }

        /**
         * Set the lcbPlcffndRef field for the FIB record.
         */
        public void SetLcbPlcffndRef(int field_59_lcbPlcffndRef)
        {
            this.field_59_lcbPlcffndRef = field_59_lcbPlcffndRef;
        }

        /**
         * Get the fcPlcffndTxt field for the FIB record.
         */
        public int GetFcPlcffndTxt()
        {
            return field_60_fcPlcffndTxt;
        }

        /**
         * Set the fcPlcffndTxt field for the FIB record.
         */
        public void SetFcPlcffndTxt(int field_60_fcPlcffndTxt)
        {
            this.field_60_fcPlcffndTxt = field_60_fcPlcffndTxt;
        }

        /**
         * Get the lcbPlcffndTxt field for the FIB record.
         */
        public int GetLcbPlcffndTxt()
        {
            return field_61_lcbPlcffndTxt;
        }

        /**
         * Set the lcbPlcffndTxt field for the FIB record.
         */
        public void SetLcbPlcffndTxt(int field_61_lcbPlcffndTxt)
        {
            this.field_61_lcbPlcffndTxt = field_61_lcbPlcffndTxt;
        }

        /**
         * Get the fcPlcfandRef field for the FIB record.
         */
        public int GetFcPlcfandRef()
        {
            return field_62_fcPlcfandRef;
        }

        /**
         * Set the fcPlcfandRef field for the FIB record.
         */
        public void SetFcPlcfandRef(int field_62_fcPlcfandRef)
        {
            this.field_62_fcPlcfandRef = field_62_fcPlcfandRef;
        }

        /**
         * Get the lcbPlcfandRef field for the FIB record.
         */
        public int GetLcbPlcfandRef()
        {
            return field_63_lcbPlcfandRef;
        }

        /**
         * Set the lcbPlcfandRef field for the FIB record.
         */
        public void SetLcbPlcfandRef(int field_63_lcbPlcfandRef)
        {
            this.field_63_lcbPlcfandRef = field_63_lcbPlcfandRef;
        }

        /**
         * Get the fcPlcfandTxt field for the FIB record.
         */
        public int GetFcPlcfandTxt()
        {
            return field_64_fcPlcfandTxt;
        }

        /**
         * Set the fcPlcfandTxt field for the FIB record.
         */
        public void SetFcPlcfandTxt(int field_64_fcPlcfandTxt)
        {
            this.field_64_fcPlcfandTxt = field_64_fcPlcfandTxt;
        }

        /**
         * Get the lcbPlcfandTxt field for the FIB record.
         */
        public int GetLcbPlcfandTxt()
        {
            return field_65_lcbPlcfandTxt;
        }

        /**
         * Set the lcbPlcfandTxt field for the FIB record.
         */
        public void SetLcbPlcfandTxt(int field_65_lcbPlcfandTxt)
        {
            this.field_65_lcbPlcfandTxt = field_65_lcbPlcfandTxt;
        }

        /**
         * Get the fcPlcfsed field for the FIB record.
         */
        public int GetFcPlcfsed()
        {
            return field_66_fcPlcfsed;
        }

        /**
         * Set the fcPlcfsed field for the FIB record.
         */
        public void SetFcPlcfsed(int field_66_fcPlcfsed)
        {
            this.field_66_fcPlcfsed = field_66_fcPlcfsed;
        }

        /**
         * Get the lcbPlcfsed field for the FIB record.
         */
        public int GetLcbPlcfsed()
        {
            return field_67_lcbPlcfsed;
        }

        /**
         * Set the lcbPlcfsed field for the FIB record.
         */
        public void SetLcbPlcfsed(int field_67_lcbPlcfsed)
        {
            this.field_67_lcbPlcfsed = field_67_lcbPlcfsed;
        }

        /**
         * Get the fcPlcpad field for the FIB record.
         */
        public int GetFcPlcpad()
        {
            return field_68_fcPlcpad;
        }

        /**
         * Set the fcPlcpad field for the FIB record.
         */
        public void SetFcPlcpad(int field_68_fcPlcpad)
        {
            this.field_68_fcPlcpad = field_68_fcPlcpad;
        }

        /**
         * Get the lcbPlcpad field for the FIB record.
         */
        public int GetLcbPlcpad()
        {
            return field_69_lcbPlcpad;
        }

        /**
         * Set the lcbPlcpad field for the FIB record.
         */
        public void SetLcbPlcpad(int field_69_lcbPlcpad)
        {
            this.field_69_lcbPlcpad = field_69_lcbPlcpad;
        }

        /**
         * Get the fcPlcfphe field for the FIB record.
         */
        public int GetFcPlcfphe()
        {
            return field_70_fcPlcfphe;
        }

        /**
         * Set the fcPlcfphe field for the FIB record.
         */
        public void SetFcPlcfphe(int field_70_fcPlcfphe)
        {
            this.field_70_fcPlcfphe = field_70_fcPlcfphe;
        }

        /**
         * Get the lcbPlcfphe field for the FIB record.
         */
        public int GetLcbPlcfphe()
        {
            return field_71_lcbPlcfphe;
        }

        /**
         * Set the lcbPlcfphe field for the FIB record.
         */
        public void SetLcbPlcfphe(int field_71_lcbPlcfphe)
        {
            this.field_71_lcbPlcfphe = field_71_lcbPlcfphe;
        }

        /**
         * Get the fcSttbfglsy field for the FIB record.
         */
        public int GetFcSttbfglsy()
        {
            return field_72_fcSttbfglsy;
        }

        /**
         * Set the fcSttbfglsy field for the FIB record.
         */
        public void SetFcSttbfglsy(int field_72_fcSttbfglsy)
        {
            this.field_72_fcSttbfglsy = field_72_fcSttbfglsy;
        }

        /**
         * Get the lcbSttbfglsy field for the FIB record.
         */
        public int GetLcbSttbfglsy()
        {
            return field_73_lcbSttbfglsy;
        }

        /**
         * Set the lcbSttbfglsy field for the FIB record.
         */
        public void SetLcbSttbfglsy(int field_73_lcbSttbfglsy)
        {
            this.field_73_lcbSttbfglsy = field_73_lcbSttbfglsy;
        }

        /**
         * Get the fcPlcfglsy field for the FIB record.
         */
        public int GetFcPlcfglsy()
        {
            return field_74_fcPlcfglsy;
        }

        /**
         * Set the fcPlcfglsy field for the FIB record.
         */
        public void SetFcPlcfglsy(int field_74_fcPlcfglsy)
        {
            this.field_74_fcPlcfglsy = field_74_fcPlcfglsy;
        }

        /**
         * Get the lcbPlcfglsy field for the FIB record.
         */
        public int GetLcbPlcfglsy()
        {
            return field_75_lcbPlcfglsy;
        }

        /**
         * Set the lcbPlcfglsy field for the FIB record.
         */
        public void SetLcbPlcfglsy(int field_75_lcbPlcfglsy)
        {
            this.field_75_lcbPlcfglsy = field_75_lcbPlcfglsy;
        }

        /**
         * Get the fcPlcfhdd field for the FIB record.
         */
        public int GetFcPlcfhdd()
        {
            return field_76_fcPlcfhdd;
        }

        /**
         * Set the fcPlcfhdd field for the FIB record.
         */
        public void SetFcPlcfhdd(int field_76_fcPlcfhdd)
        {
            this.field_76_fcPlcfhdd = field_76_fcPlcfhdd;
        }

        /**
         * Get the lcbPlcfhdd field for the FIB record.
         */
        public int GetLcbPlcfhdd()
        {
            return field_77_lcbPlcfhdd;
        }

        /**
         * Set the lcbPlcfhdd field for the FIB record.
         */
        public void SetLcbPlcfhdd(int field_77_lcbPlcfhdd)
        {
            this.field_77_lcbPlcfhdd = field_77_lcbPlcfhdd;
        }

        /**
         * Get the fcPlcfbteChpx field for the FIB record.
         */
        public int GetFcPlcfbteChpx()
        {
            return field_78_fcPlcfbteChpx;
        }

        /**
         * Set the fcPlcfbteChpx field for the FIB record.
         */
        public void SetFcPlcfbteChpx(int field_78_fcPlcfbteChpx)
        {
            this.field_78_fcPlcfbteChpx = field_78_fcPlcfbteChpx;
        }

        /**
         * Get the lcbPlcfbteChpx field for the FIB record.
         */
        public int GetLcbPlcfbteChpx()
        {
            return field_79_lcbPlcfbteChpx;
        }

        /**
         * Set the lcbPlcfbteChpx field for the FIB record.
         */
        public void SetLcbPlcfbteChpx(int field_79_lcbPlcfbteChpx)
        {
            this.field_79_lcbPlcfbteChpx = field_79_lcbPlcfbteChpx;
        }

        /**
         * Get the fcPlcfbtePapx field for the FIB record.
         */
        public int GetFcPlcfbtePapx()
        {
            return field_80_fcPlcfbtePapx;
        }

        /**
         * Set the fcPlcfbtePapx field for the FIB record.
         */
        public void SetFcPlcfbtePapx(int field_80_fcPlcfbtePapx)
        {
            this.field_80_fcPlcfbtePapx = field_80_fcPlcfbtePapx;
        }

        /**
         * Get the lcbPlcfbtePapx field for the FIB record.
         */
        public int GetLcbPlcfbtePapx()
        {
            return field_81_lcbPlcfbtePapx;
        }

        /**
         * Set the lcbPlcfbtePapx field for the FIB record.
         */
        public void SetLcbPlcfbtePapx(int field_81_lcbPlcfbtePapx)
        {
            this.field_81_lcbPlcfbtePapx = field_81_lcbPlcfbtePapx;
        }

        /**
         * Get the fcPlcfsea field for the FIB record.
         */
        public int GetFcPlcfsea()
        {
            return field_82_fcPlcfsea;
        }

        /**
         * Set the fcPlcfsea field for the FIB record.
         */
        public void SetFcPlcfsea(int field_82_fcPlcfsea)
        {
            this.field_82_fcPlcfsea = field_82_fcPlcfsea;
        }

        /**
         * Get the lcbPlcfsea field for the FIB record.
         */
        public int GetLcbPlcfsea()
        {
            return field_83_lcbPlcfsea;
        }

        /**
         * Set the lcbPlcfsea field for the FIB record.
         */
        public void SetLcbPlcfsea(int field_83_lcbPlcfsea)
        {
            this.field_83_lcbPlcfsea = field_83_lcbPlcfsea;
        }

        /**
         * Get the fcSttbfffn field for the FIB record.
         */
        public int GetFcSttbfffn()
        {
            return field_84_fcSttbfffn;
        }

        /**
         * Set the fcSttbfffn field for the FIB record.
         */
        public void SetFcSttbfffn(int field_84_fcSttbfffn)
        {
            this.field_84_fcSttbfffn = field_84_fcSttbfffn;
        }

        /**
         * Get the lcbSttbfffn field for the FIB record.
         */
        public int GetLcbSttbfffn()
        {
            return field_85_lcbSttbfffn;
        }

        /**
         * Set the lcbSttbfffn field for the FIB record.
         */
        public void SetLcbSttbfffn(int field_85_lcbSttbfffn)
        {
            this.field_85_lcbSttbfffn = field_85_lcbSttbfffn;
        }

        /**
         * Get the fcPlcffldMom field for the FIB record.
         */
        public int GetFcPlcffldMom()
        {
            return field_86_fcPlcffldMom;
        }

        /**
         * Set the fcPlcffldMom field for the FIB record.
         */
        public void SetFcPlcffldMom(int field_86_fcPlcffldMom)
        {
            this.field_86_fcPlcffldMom = field_86_fcPlcffldMom;
        }

        /**
         * Get the lcbPlcffldMom field for the FIB record.
         */
        public int GetLcbPlcffldMom()
        {
            return field_87_lcbPlcffldMom;
        }

        /**
         * Set the lcbPlcffldMom field for the FIB record.
         */
        public void SetLcbPlcffldMom(int field_87_lcbPlcffldMom)
        {
            this.field_87_lcbPlcffldMom = field_87_lcbPlcffldMom;
        }

        /**
         * Get the fcPlcffldHdr field for the FIB record.
         */
        public int GetFcPlcffldHdr()
        {
            return field_88_fcPlcffldHdr;
        }

        /**
         * Set the fcPlcffldHdr field for the FIB record.
         */
        public void SetFcPlcffldHdr(int field_88_fcPlcffldHdr)
        {
            this.field_88_fcPlcffldHdr = field_88_fcPlcffldHdr;
        }

        /**
         * Get the lcbPlcffldHdr field for the FIB record.
         */
        public int GetLcbPlcffldHdr()
        {
            return field_89_lcbPlcffldHdr;
        }

        /**
         * Set the lcbPlcffldHdr field for the FIB record.
         */
        public void SetLcbPlcffldHdr(int field_89_lcbPlcffldHdr)
        {
            this.field_89_lcbPlcffldHdr = field_89_lcbPlcffldHdr;
        }

        /**
         * Get the fcPlcffldFtn field for the FIB record.
         */
        public int GetFcPlcffldFtn()
        {
            return field_90_fcPlcffldFtn;
        }

        /**
         * Set the fcPlcffldFtn field for the FIB record.
         */
        public void SetFcPlcffldFtn(int field_90_fcPlcffldFtn)
        {
            this.field_90_fcPlcffldFtn = field_90_fcPlcffldFtn;
        }

        /**
         * Get the lcbPlcffldFtn field for the FIB record.
         */
        public int GetLcbPlcffldFtn()
        {
            return field_91_lcbPlcffldFtn;
        }

        /**
         * Set the lcbPlcffldFtn field for the FIB record.
         */
        public void SetLcbPlcffldFtn(int field_91_lcbPlcffldFtn)
        {
            this.field_91_lcbPlcffldFtn = field_91_lcbPlcffldFtn;
        }

        /**
         * Get the fcPlcffldAtn field for the FIB record.
         */
        public int GetFcPlcffldAtn()
        {
            return field_92_fcPlcffldAtn;
        }

        /**
         * Set the fcPlcffldAtn field for the FIB record.
         */
        public void SetFcPlcffldAtn(int field_92_fcPlcffldAtn)
        {
            this.field_92_fcPlcffldAtn = field_92_fcPlcffldAtn;
        }

        /**
         * Get the lcbPlcffldAtn field for the FIB record.
         */
        public int GetLcbPlcffldAtn()
        {
            return field_93_lcbPlcffldAtn;
        }

        /**
         * Set the lcbPlcffldAtn field for the FIB record.
         */
        public void SetLcbPlcffldAtn(int field_93_lcbPlcffldAtn)
        {
            this.field_93_lcbPlcffldAtn = field_93_lcbPlcffldAtn;
        }

        /**
         * Get the fcPlcffldMcr field for the FIB record.
         */
        public int GetFcPlcffldMcr()
        {
            return field_94_fcPlcffldMcr;
        }

        /**
         * Set the fcPlcffldMcr field for the FIB record.
         */
        public void SetFcPlcffldMcr(int field_94_fcPlcffldMcr)
        {
            this.field_94_fcPlcffldMcr = field_94_fcPlcffldMcr;
        }

        /**
         * Get the lcbPlcffldMcr field for the FIB record.
         */
        public int GetLcbPlcffldMcr()
        {
            return field_95_lcbPlcffldMcr;
        }

        /**
         * Set the lcbPlcffldMcr field for the FIB record.
         */
        public void SetLcbPlcffldMcr(int field_95_lcbPlcffldMcr)
        {
            this.field_95_lcbPlcffldMcr = field_95_lcbPlcffldMcr;
        }

        /**
         * Get the fcSttbfbkmk field for the FIB record.
         */
        public int GetFcSttbfbkmk()
        {
            return field_96_fcSttbfbkmk;
        }

        /**
         * Set the fcSttbfbkmk field for the FIB record.
         */
        public void SetFcSttbfbkmk(int field_96_fcSttbfbkmk)
        {
            this.field_96_fcSttbfbkmk = field_96_fcSttbfbkmk;
        }

        /**
         * Get the lcbSttbfbkmk field for the FIB record.
         */
        public int GetLcbSttbfbkmk()
        {
            return field_97_lcbSttbfbkmk;
        }

        /**
         * Set the lcbSttbfbkmk field for the FIB record.
         */
        public void SetLcbSttbfbkmk(int field_97_lcbSttbfbkmk)
        {
            this.field_97_lcbSttbfbkmk = field_97_lcbSttbfbkmk;
        }

        /**
         * Get the fcPlcfbkf field for the FIB record.
         */
        public int GetFcPlcfbkf()
        {
            return field_98_fcPlcfbkf;
        }

        /**
         * Set the fcPlcfbkf field for the FIB record.
         */
        public void SetFcPlcfbkf(int field_98_fcPlcfbkf)
        {
            this.field_98_fcPlcfbkf = field_98_fcPlcfbkf;
        }

        /**
         * Get the lcbPlcfbkf field for the FIB record.
         */
        public int GetLcbPlcfbkf()
        {
            return field_99_lcbPlcfbkf;
        }

        /**
         * Set the lcbPlcfbkf field for the FIB record.
         */
        public void SetLcbPlcfbkf(int field_99_lcbPlcfbkf)
        {
            this.field_99_lcbPlcfbkf = field_99_lcbPlcfbkf;
        }

        /**
         * Get the fcPlcfbkl field for the FIB record.
         */
        public int GetFcPlcfbkl()
        {
            return field_100_fcPlcfbkl;
        }

        /**
         * Set the fcPlcfbkl field for the FIB record.
         */
        public void SetFcPlcfbkl(int field_100_fcPlcfbkl)
        {
            this.field_100_fcPlcfbkl = field_100_fcPlcfbkl;
        }

        /**
         * Get the lcbPlcfbkl field for the FIB record.
         */
        public int GetLcbPlcfbkl()
        {
            return field_101_lcbPlcfbkl;
        }

        /**
         * Set the lcbPlcfbkl field for the FIB record.
         */
        public void SetLcbPlcfbkl(int field_101_lcbPlcfbkl)
        {
            this.field_101_lcbPlcfbkl = field_101_lcbPlcfbkl;
        }

        /**
         * Get the fcCmds field for the FIB record.
         */
        public int GetFcCmds()
        {
            return field_102_fcCmds;
        }

        /**
         * Set the fcCmds field for the FIB record.
         */
        public void SetFcCmds(int field_102_fcCmds)
        {
            this.field_102_fcCmds = field_102_fcCmds;
        }

        /**
         * Get the lcbCmds field for the FIB record.
         */
        public int GetLcbCmds()
        {
            return field_103_lcbCmds;
        }

        /**
         * Set the lcbCmds field for the FIB record.
         */
        public void SetLcbCmds(int field_103_lcbCmds)
        {
            this.field_103_lcbCmds = field_103_lcbCmds;
        }

        /**
         * Get the fcPlcmcr field for the FIB record.
         */
        public int GetFcPlcmcr()
        {
            return field_104_fcPlcmcr;
        }

        /**
         * Set the fcPlcmcr field for the FIB record.
         */
        public void SetFcPlcmcr(int field_104_fcPlcmcr)
        {
            this.field_104_fcPlcmcr = field_104_fcPlcmcr;
        }

        /**
         * Get the lcbPlcmcr field for the FIB record.
         */
        public int GetLcbPlcmcr()
        {
            return field_105_lcbPlcmcr;
        }

        /**
         * Set the lcbPlcmcr field for the FIB record.
         */
        public void SetLcbPlcmcr(int field_105_lcbPlcmcr)
        {
            this.field_105_lcbPlcmcr = field_105_lcbPlcmcr;
        }

        /**
         * Get the fcSttbfmcr field for the FIB record.
         */
        public int GetFcSttbfmcr()
        {
            return field_106_fcSttbfmcr;
        }

        /**
         * Set the fcSttbfmcr field for the FIB record.
         */
        public void SetFcSttbfmcr(int field_106_fcSttbfmcr)
        {
            this.field_106_fcSttbfmcr = field_106_fcSttbfmcr;
        }

        /**
         * Get the lcbSttbfmcr field for the FIB record.
         */
        public int GetLcbSttbfmcr()
        {
            return field_107_lcbSttbfmcr;
        }

        /**
         * Set the lcbSttbfmcr field for the FIB record.
         */
        public void SetLcbSttbfmcr(int field_107_lcbSttbfmcr)
        {
            this.field_107_lcbSttbfmcr = field_107_lcbSttbfmcr;
        }

        /**
         * Get the fcPrDrvr field for the FIB record.
         */
        public int GetFcPrDrvr()
        {
            return field_108_fcPrDrvr;
        }

        /**
         * Set the fcPrDrvr field for the FIB record.
         */
        public void SetFcPrDrvr(int field_108_fcPrDrvr)
        {
            this.field_108_fcPrDrvr = field_108_fcPrDrvr;
        }

        /**
         * Get the lcbPrDrvr field for the FIB record.
         */
        public int GetLcbPrDrvr()
        {
            return field_109_lcbPrDrvr;
        }

        /**
         * Set the lcbPrDrvr field for the FIB record.
         */
        public void SetLcbPrDrvr(int field_109_lcbPrDrvr)
        {
            this.field_109_lcbPrDrvr = field_109_lcbPrDrvr;
        }

        /**
         * Get the fcPrEnvPort field for the FIB record.
         */
        public int GetFcPrEnvPort()
        {
            return field_110_fcPrEnvPort;
        }

        /**
         * Set the fcPrEnvPort field for the FIB record.
         */
        public void SetFcPrEnvPort(int field_110_fcPrEnvPort)
        {
            this.field_110_fcPrEnvPort = field_110_fcPrEnvPort;
        }

        /**
         * Get the lcbPrEnvPort field for the FIB record.
         */
        public int GetLcbPrEnvPort()
        {
            return field_111_lcbPrEnvPort;
        }

        /**
         * Set the lcbPrEnvPort field for the FIB record.
         */
        public void SetLcbPrEnvPort(int field_111_lcbPrEnvPort)
        {
            this.field_111_lcbPrEnvPort = field_111_lcbPrEnvPort;
        }

        /**
         * Get the fcPrEnvLand field for the FIB record.
         */
        public int GetFcPrEnvLand()
        {
            return field_112_fcPrEnvLand;
        }

        /**
         * Set the fcPrEnvLand field for the FIB record.
         */
        public void SetFcPrEnvLand(int field_112_fcPrEnvLand)
        {
            this.field_112_fcPrEnvLand = field_112_fcPrEnvLand;
        }

        /**
         * Get the lcbPrEnvLand field for the FIB record.
         */
        public int GetLcbPrEnvLand()
        {
            return field_113_lcbPrEnvLand;
        }

        /**
         * Set the lcbPrEnvLand field for the FIB record.
         */
        public void SetLcbPrEnvLand(int field_113_lcbPrEnvLand)
        {
            this.field_113_lcbPrEnvLand = field_113_lcbPrEnvLand;
        }

        /**
         * Get the fcWss field for the FIB record.
         */
        public int GetFcWss()
        {
            return field_114_fcWss;
        }

        /**
         * Set the fcWss field for the FIB record.
         */
        public void SetFcWss(int field_114_fcWss)
        {
            this.field_114_fcWss = field_114_fcWss;
        }

        /**
         * Get the lcbWss field for the FIB record.
         */
        public int GetLcbWss()
        {
            return field_115_lcbWss;
        }

        /**
         * Set the lcbWss field for the FIB record.
         */
        public void SetLcbWss(int field_115_lcbWss)
        {
            this.field_115_lcbWss = field_115_lcbWss;
        }

        /**
         * Get the fcDop field for the FIB record.
         */
        public int GetFcDop()
        {
            return field_116_fcDop;
        }

        /**
         * Set the fcDop field for the FIB record.
         */
        public void SetFcDop(int field_116_fcDop)
        {
            this.field_116_fcDop = field_116_fcDop;
        }

        /**
         * Get the lcbDop field for the FIB record.
         */
        public int GetLcbDop()
        {
            return field_117_lcbDop;
        }

        /**
         * Set the lcbDop field for the FIB record.
         */
        public void SetLcbDop(int field_117_lcbDop)
        {
            this.field_117_lcbDop = field_117_lcbDop;
        }

        /**
         * Get the fcSttbfAssoc field for the FIB record.
         */
        public int GetFcSttbfAssoc()
        {
            return field_118_fcSttbfAssoc;
        }

        /**
         * Set the fcSttbfAssoc field for the FIB record.
         */
        public void SetFcSttbfAssoc(int field_118_fcSttbfAssoc)
        {
            this.field_118_fcSttbfAssoc = field_118_fcSttbfAssoc;
        }

        /**
         * Get the lcbSttbfAssoc field for the FIB record.
         */
        public int GetLcbSttbfAssoc()
        {
            return field_119_lcbSttbfAssoc;
        }

        /**
         * Set the lcbSttbfAssoc field for the FIB record.
         */
        public void SetLcbSttbfAssoc(int field_119_lcbSttbfAssoc)
        {
            this.field_119_lcbSttbfAssoc = field_119_lcbSttbfAssoc;
        }

        /**
         * Get the fcClx field for the FIB record.
         */
        public int GetFcClx()
        {
            return field_120_fcClx;
        }

        /**
         * Set the fcClx field for the FIB record.
         */
        public void SetFcClx(int field_120_fcClx)
        {
            this.field_120_fcClx = field_120_fcClx;
        }

        /**
         * Get the lcbClx field for the FIB record.
         */
        public int GetLcbClx()
        {
            return field_121_lcbClx;
        }

        /**
         * Set the lcbClx field for the FIB record.
         */
        public void SetLcbClx(int field_121_lcbClx)
        {
            this.field_121_lcbClx = field_121_lcbClx;
        }

        /**
         * Get the fcPlcfpgdFtn field for the FIB record.
         */
        public int GetFcPlcfpgdFtn()
        {
            return field_122_fcPlcfpgdFtn;
        }

        /**
         * Set the fcPlcfpgdFtn field for the FIB record.
         */
        public void SetFcPlcfpgdFtn(int field_122_fcPlcfpgdFtn)
        {
            this.field_122_fcPlcfpgdFtn = field_122_fcPlcfpgdFtn;
        }

        /**
         * Get the lcbPlcfpgdFtn field for the FIB record.
         */
        public int GetLcbPlcfpgdFtn()
        {
            return field_123_lcbPlcfpgdFtn;
        }

        /**
         * Set the lcbPlcfpgdFtn field for the FIB record.
         */
        public void SetLcbPlcfpgdFtn(int field_123_lcbPlcfpgdFtn)
        {
            this.field_123_lcbPlcfpgdFtn = field_123_lcbPlcfpgdFtn;
        }

        /**
         * Get the fcAutosaveSource field for the FIB record.
         */
        public int GetFcAutosaveSource()
        {
            return field_124_fcAutosaveSource;
        }

        /**
         * Set the fcAutosaveSource field for the FIB record.
         */
        public void SetFcAutosaveSource(int field_124_fcAutosaveSource)
        {
            this.field_124_fcAutosaveSource = field_124_fcAutosaveSource;
        }

        /**
         * Get the lcbAutosaveSource field for the FIB record.
         */
        public int GetLcbAutosaveSource()
        {
            return field_125_lcbAutosaveSource;
        }

        /**
         * Set the lcbAutosaveSource field for the FIB record.
         */
        public void SetLcbAutosaveSource(int field_125_lcbAutosaveSource)
        {
            this.field_125_lcbAutosaveSource = field_125_lcbAutosaveSource;
        }

        /**
         * Get the fcGrpXstAtnOwners field for the FIB record.
         */
        public int GetFcGrpXstAtnOwners()
        {
            return field_126_fcGrpXstAtnOwners;
        }

        /**
         * Set the fcGrpXstAtnOwners field for the FIB record.
         */
        public void SetFcGrpXstAtnOwners(int field_126_fcGrpXstAtnOwners)
        {
            this.field_126_fcGrpXstAtnOwners = field_126_fcGrpXstAtnOwners;
        }

        /**
         * Get the lcbGrpXstAtnOwners field for the FIB record.
         */
        public int GetLcbGrpXstAtnOwners()
        {
            return field_127_lcbGrpXstAtnOwners;
        }

        /**
         * Set the lcbGrpXstAtnOwners field for the FIB record.
         */
        public void SetLcbGrpXstAtnOwners(int field_127_lcbGrpXstAtnOwners)
        {
            this.field_127_lcbGrpXstAtnOwners = field_127_lcbGrpXstAtnOwners;
        }

        /**
         * Get the fcSttbfAtnbkmk field for the FIB record.
         */
        public int GetFcSttbfAtnbkmk()
        {
            return field_128_fcSttbfAtnbkmk;
        }

        /**
         * Set the fcSttbfAtnbkmk field for the FIB record.
         */
        public void SetFcSttbfAtnbkmk(int field_128_fcSttbfAtnbkmk)
        {
            this.field_128_fcSttbfAtnbkmk = field_128_fcSttbfAtnbkmk;
        }

        /**
         * Get the lcbSttbfAtnbkmk field for the FIB record.
         */
        public int GetLcbSttbfAtnbkmk()
        {
            return field_129_lcbSttbfAtnbkmk;
        }

        /**
         * Set the lcbSttbfAtnbkmk field for the FIB record.
         */
        public void SetLcbSttbfAtnbkmk(int field_129_lcbSttbfAtnbkmk)
        {
            this.field_129_lcbSttbfAtnbkmk = field_129_lcbSttbfAtnbkmk;
        }

        /**
         * Get the fcPlcdoaMom field for the FIB record.
         */
        public int GetFcPlcdoaMom()
        {
            return field_130_fcPlcdoaMom;
        }

        /**
         * Set the fcPlcdoaMom field for the FIB record.
         */
        public void SetFcPlcdoaMom(int field_130_fcPlcdoaMom)
        {
            this.field_130_fcPlcdoaMom = field_130_fcPlcdoaMom;
        }

        /**
         * Get the lcbPlcdoaMom field for the FIB record.
         */
        public int GetLcbPlcdoaMom()
        {
            return field_131_lcbPlcdoaMom;
        }

        /**
         * Set the lcbPlcdoaMom field for the FIB record.
         */
        public void SetLcbPlcdoaMom(int field_131_lcbPlcdoaMom)
        {
            this.field_131_lcbPlcdoaMom = field_131_lcbPlcdoaMom;
        }

        /**
         * Get the fcPlcdoaHdr field for the FIB record.
         */
        public int GetFcPlcdoaHdr()
        {
            return field_132_fcPlcdoaHdr;
        }

        /**
         * Set the fcPlcdoaHdr field for the FIB record.
         */
        public void SetFcPlcdoaHdr(int field_132_fcPlcdoaHdr)
        {
            this.field_132_fcPlcdoaHdr = field_132_fcPlcdoaHdr;
        }

        /**
         * Get the lcbPlcdoaHdr field for the FIB record.
         */
        public int GetLcbPlcdoaHdr()
        {
            return field_133_lcbPlcdoaHdr;
        }

        /**
         * Set the lcbPlcdoaHdr field for the FIB record.
         */
        public void SetLcbPlcdoaHdr(int field_133_lcbPlcdoaHdr)
        {
            this.field_133_lcbPlcdoaHdr = field_133_lcbPlcdoaHdr;
        }

        /**
         * Get the fcPlcspaMom field for the FIB record.
         */
        public int GetFcPlcspaMom()
        {
            return field_134_fcPlcspaMom;
        }

        /**
         * Set the fcPlcspaMom field for the FIB record.
         */
        public void SetFcPlcspaMom(int field_134_fcPlcspaMom)
        {
            this.field_134_fcPlcspaMom = field_134_fcPlcspaMom;
        }

        /**
         * Get the lcbPlcspaMom field for the FIB record.
         */
        public int GetLcbPlcspaMom()
        {
            return field_135_lcbPlcspaMom;
        }

        /**
         * Set the lcbPlcspaMom field for the FIB record.
         */
        public void SetLcbPlcspaMom(int field_135_lcbPlcspaMom)
        {
            this.field_135_lcbPlcspaMom = field_135_lcbPlcspaMom;
        }

        /**
         * Get the fcPlcspaHdr field for the FIB record.
         */
        public int GetFcPlcspaHdr()
        {
            return field_136_fcPlcspaHdr;
        }

        /**
         * Set the fcPlcspaHdr field for the FIB record.
         */
        public void SetFcPlcspaHdr(int field_136_fcPlcspaHdr)
        {
            this.field_136_fcPlcspaHdr = field_136_fcPlcspaHdr;
        }

        /**
         * Get the lcbPlcspaHdr field for the FIB record.
         */
        public int GetLcbPlcspaHdr()
        {
            return field_137_lcbPlcspaHdr;
        }

        /**
         * Set the lcbPlcspaHdr field for the FIB record.
         */
        public void SetLcbPlcspaHdr(int field_137_lcbPlcspaHdr)
        {
            this.field_137_lcbPlcspaHdr = field_137_lcbPlcspaHdr;
        }

        /**
         * Get the fcPlcfAtnbkf field for the FIB record.
         */
        public int GetFcPlcfAtnbkf()
        {
            return field_138_fcPlcfAtnbkf;
        }

        /**
         * Set the fcPlcfAtnbkf field for the FIB record.
         */
        public void SetFcPlcfAtnbkf(int field_138_fcPlcfAtnbkf)
        {
            this.field_138_fcPlcfAtnbkf = field_138_fcPlcfAtnbkf;
        }

        /**
         * Get the lcbPlcfAtnbkf field for the FIB record.
         */
        public int GetLcbPlcfAtnbkf()
        {
            return field_139_lcbPlcfAtnbkf;
        }

        /**
         * Set the lcbPlcfAtnbkf field for the FIB record.
         */
        public void SetLcbPlcfAtnbkf(int field_139_lcbPlcfAtnbkf)
        {
            this.field_139_lcbPlcfAtnbkf = field_139_lcbPlcfAtnbkf;
        }

        /**
         * Get the fcPlcfAtnbkl field for the FIB record.
         */
        public int GetFcPlcfAtnbkl()
        {
            return field_140_fcPlcfAtnbkl;
        }

        /**
         * Set the fcPlcfAtnbkl field for the FIB record.
         */
        public void SetFcPlcfAtnbkl(int field_140_fcPlcfAtnbkl)
        {
            this.field_140_fcPlcfAtnbkl = field_140_fcPlcfAtnbkl;
        }

        /**
         * Get the lcbPlcfAtnbkl field for the FIB record.
         */
        public int GetLcbPlcfAtnbkl()
        {
            return field_141_lcbPlcfAtnbkl;
        }

        /**
         * Set the lcbPlcfAtnbkl field for the FIB record.
         */
        public void SetLcbPlcfAtnbkl(int field_141_lcbPlcfAtnbkl)
        {
            this.field_141_lcbPlcfAtnbkl = field_141_lcbPlcfAtnbkl;
        }

        /**
         * Get the fcPms field for the FIB record.
         */
        public int GetFcPms()
        {
            return field_142_fcPms;
        }

        /**
         * Set the fcPms field for the FIB record.
         */
        public void SetFcPms(int field_142_fcPms)
        {
            this.field_142_fcPms = field_142_fcPms;
        }

        /**
         * Get the lcbPms field for the FIB record.
         */
        public int GetLcbPms()
        {
            return field_143_lcbPms;
        }

        /**
         * Set the lcbPms field for the FIB record.
         */
        public void SetLcbPms(int field_143_lcbPms)
        {
            this.field_143_lcbPms = field_143_lcbPms;
        }

        /**
         * Get the fcFormFldSttbs field for the FIB record.
         */
        public int GetFcFormFldSttbs()
        {
            return field_144_fcFormFldSttbs;
        }

        /**
         * Set the fcFormFldSttbs field for the FIB record.
         */
        public void SetFcFormFldSttbs(int field_144_fcFormFldSttbs)
        {
            this.field_144_fcFormFldSttbs = field_144_fcFormFldSttbs;
        }

        /**
         * Get the lcbFormFldSttbs field for the FIB record.
         */
        public int GetLcbFormFldSttbs()
        {
            return field_145_lcbFormFldSttbs;
        }

        /**
         * Set the lcbFormFldSttbs field for the FIB record.
         */
        public void SetLcbFormFldSttbs(int field_145_lcbFormFldSttbs)
        {
            this.field_145_lcbFormFldSttbs = field_145_lcbFormFldSttbs;
        }

        /**
         * Get the fcPlcfendRef field for the FIB record.
         */
        public int GetFcPlcfendRef()
        {
            return field_146_fcPlcfendRef;
        }

        /**
         * Set the fcPlcfendRef field for the FIB record.
         */
        public void SetFcPlcfendRef(int field_146_fcPlcfendRef)
        {
            this.field_146_fcPlcfendRef = field_146_fcPlcfendRef;
        }

        /**
         * Get the lcbPlcfendRef field for the FIB record.
         */
        public int GetLcbPlcfendRef()
        {
            return field_147_lcbPlcfendRef;
        }

        /**
         * Set the lcbPlcfendRef field for the FIB record.
         */
        public void SetLcbPlcfendRef(int field_147_lcbPlcfendRef)
        {
            this.field_147_lcbPlcfendRef = field_147_lcbPlcfendRef;
        }

        /**
         * Get the fcPlcfendTxt field for the FIB record.
         */
        public int GetFcPlcfendTxt()
        {
            return field_148_fcPlcfendTxt;
        }

        /**
         * Set the fcPlcfendTxt field for the FIB record.
         */
        public void SetFcPlcfendTxt(int field_148_fcPlcfendTxt)
        {
            this.field_148_fcPlcfendTxt = field_148_fcPlcfendTxt;
        }

        /**
         * Get the lcbPlcfendTxt field for the FIB record.
         */
        public int GetLcbPlcfendTxt()
        {
            return field_149_lcbPlcfendTxt;
        }

        /**
         * Set the lcbPlcfendTxt field for the FIB record.
         */
        public void SetLcbPlcfendTxt(int field_149_lcbPlcfendTxt)
        {
            this.field_149_lcbPlcfendTxt = field_149_lcbPlcfendTxt;
        }

        /**
         * Get the fcPlcffldEdn field for the FIB record.
         */
        public int GetFcPlcffldEdn()
        {
            return field_150_fcPlcffldEdn;
        }

        /**
         * Set the fcPlcffldEdn field for the FIB record.
         */
        public void SetFcPlcffldEdn(int field_150_fcPlcffldEdn)
        {
            this.field_150_fcPlcffldEdn = field_150_fcPlcffldEdn;
        }

        /**
         * Get the lcbPlcffldEdn field for the FIB record.
         */
        public int GetLcbPlcffldEdn()
        {
            return field_151_lcbPlcffldEdn;
        }

        /**
         * Set the lcbPlcffldEdn field for the FIB record.
         */
        public void SetLcbPlcffldEdn(int field_151_lcbPlcffldEdn)
        {
            this.field_151_lcbPlcffldEdn = field_151_lcbPlcffldEdn;
        }

        /**
         * Get the fcPlcfpgdEdn field for the FIB record.
         */
        public int GetFcPlcfpgdEdn()
        {
            return field_152_fcPlcfpgdEdn;
        }

        /**
         * Set the fcPlcfpgdEdn field for the FIB record.
         */
        public void SetFcPlcfpgdEdn(int field_152_fcPlcfpgdEdn)
        {
            this.field_152_fcPlcfpgdEdn = field_152_fcPlcfpgdEdn;
        }

        /**
         * Get the lcbPlcfpgdEdn field for the FIB record.
         */
        public int GetLcbPlcfpgdEdn()
        {
            return field_153_lcbPlcfpgdEdn;
        }

        /**
         * Set the lcbPlcfpgdEdn field for the FIB record.
         */
        public void SetLcbPlcfpgdEdn(int field_153_lcbPlcfpgdEdn)
        {
            this.field_153_lcbPlcfpgdEdn = field_153_lcbPlcfpgdEdn;
        }

        /**
         * Get the fcDggInfo field for the FIB record.
         */
        public int GetFcDggInfo()
        {
            return field_154_fcDggInfo;
        }

        /**
         * Set the fcDggInfo field for the FIB record.
         */
        public void SetFcDggInfo(int field_154_fcDggInfo)
        {
            this.field_154_fcDggInfo = field_154_fcDggInfo;
        }

        /**
         * Get the lcbDggInfo field for the FIB record.
         */
        public int GetLcbDggInfo()
        {
            return field_155_lcbDggInfo;
        }

        /**
         * Set the lcbDggInfo field for the FIB record.
         */
        public void SetLcbDggInfo(int field_155_lcbDggInfo)
        {
            this.field_155_lcbDggInfo = field_155_lcbDggInfo;
        }

        /**
         * Get the fcSttbfRMark field for the FIB record.
         */
        public int GetFcSttbfRMark()
        {
            return field_156_fcSttbfRMark;
        }

        /**
         * Set the fcSttbfRMark field for the FIB record.
         */
        public void SetFcSttbfRMark(int field_156_fcSttbfRMark)
        {
            this.field_156_fcSttbfRMark = field_156_fcSttbfRMark;
        }

        /**
         * Get the lcbSttbfRMark field for the FIB record.
         */
        public int GetLcbSttbfRMark()
        {
            return field_157_lcbSttbfRMark;
        }

        /**
         * Set the lcbSttbfRMark field for the FIB record.
         */
        public void SetLcbSttbfRMark(int field_157_lcbSttbfRMark)
        {
            this.field_157_lcbSttbfRMark = field_157_lcbSttbfRMark;
        }

        /**
         * Get the fcSttbCaption field for the FIB record.
         */
        public int GetFcSttbCaption()
        {
            return field_158_fcSttbCaption;
        }

        /**
         * Set the fcSttbCaption field for the FIB record.
         */
        public void SetFcSttbCaption(int field_158_fcSttbCaption)
        {
            this.field_158_fcSttbCaption = field_158_fcSttbCaption;
        }

        /**
         * Get the lcbSttbCaption field for the FIB record.
         */
        public int GetLcbSttbCaption()
        {
            return field_159_lcbSttbCaption;
        }

        /**
         * Set the lcbSttbCaption field for the FIB record.
         */
        public void SetLcbSttbCaption(int field_159_lcbSttbCaption)
        {
            this.field_159_lcbSttbCaption = field_159_lcbSttbCaption;
        }

        /**
         * Get the fcSttbAutoCaption field for the FIB record.
         */
        public int GetFcSttbAutoCaption()
        {
            return field_160_fcSttbAutoCaption;
        }

        /**
         * Set the fcSttbAutoCaption field for the FIB record.
         */
        public void SetFcSttbAutoCaption(int field_160_fcSttbAutoCaption)
        {
            this.field_160_fcSttbAutoCaption = field_160_fcSttbAutoCaption;
        }

        /**
         * Get the lcbSttbAutoCaption field for the FIB record.
         */
        public int GetLcbSttbAutoCaption()
        {
            return field_161_lcbSttbAutoCaption;
        }

        /**
         * Set the lcbSttbAutoCaption field for the FIB record.
         */
        public void SetLcbSttbAutoCaption(int field_161_lcbSttbAutoCaption)
        {
            this.field_161_lcbSttbAutoCaption = field_161_lcbSttbAutoCaption;
        }

        /**
         * Get the fcPlcfwkb field for the FIB record.
         */
        public int GetFcPlcfwkb()
        {
            return field_162_fcPlcfwkb;
        }

        /**
         * Set the fcPlcfwkb field for the FIB record.
         */
        public void SetFcPlcfwkb(int field_162_fcPlcfwkb)
        {
            this.field_162_fcPlcfwkb = field_162_fcPlcfwkb;
        }

        /**
         * Get the lcbPlcfwkb field for the FIB record.
         */
        public int GetLcbPlcfwkb()
        {
            return field_163_lcbPlcfwkb;
        }

        /**
         * Set the lcbPlcfwkb field for the FIB record.
         */
        public void SetLcbPlcfwkb(int field_163_lcbPlcfwkb)
        {
            this.field_163_lcbPlcfwkb = field_163_lcbPlcfwkb;
        }

        /**
         * Get the fcPlcfspl field for the FIB record.
         */
        public int GetFcPlcfspl()
        {
            return field_164_fcPlcfspl;
        }

        /**
         * Set the fcPlcfspl field for the FIB record.
         */
        public void SetFcPlcfspl(int field_164_fcPlcfspl)
        {
            this.field_164_fcPlcfspl = field_164_fcPlcfspl;
        }

        /**
         * Get the lcbPlcfspl field for the FIB record.
         */
        public int GetLcbPlcfspl()
        {
            return field_165_lcbPlcfspl;
        }

        /**
         * Set the lcbPlcfspl field for the FIB record.
         */
        public void SetLcbPlcfspl(int field_165_lcbPlcfspl)
        {
            this.field_165_lcbPlcfspl = field_165_lcbPlcfspl;
        }

        /**
         * Get the fcPlcftxbxTxt field for the FIB record.
         */
        public int GetFcPlcftxbxTxt()
        {
            return field_166_fcPlcftxbxTxt;
        }

        /**
         * Set the fcPlcftxbxTxt field for the FIB record.
         */
        public void SetFcPlcftxbxTxt(int field_166_fcPlcftxbxTxt)
        {
            this.field_166_fcPlcftxbxTxt = field_166_fcPlcftxbxTxt;
        }

        /**
         * Get the lcbPlcftxbxTxt field for the FIB record.
         */
        public int GetLcbPlcftxbxTxt()
        {
            return field_167_lcbPlcftxbxTxt;
        }

        /**
         * Set the lcbPlcftxbxTxt field for the FIB record.
         */
        public void SetLcbPlcftxbxTxt(int field_167_lcbPlcftxbxTxt)
        {
            this.field_167_lcbPlcftxbxTxt = field_167_lcbPlcftxbxTxt;
        }

        /**
         * Get the fcPlcffldTxbx field for the FIB record.
         */
        public int GetFcPlcffldTxbx()
        {
            return field_168_fcPlcffldTxbx;
        }

        /**
         * Set the fcPlcffldTxbx field for the FIB record.
         */
        public void SetFcPlcffldTxbx(int field_168_fcPlcffldTxbx)
        {
            this.field_168_fcPlcffldTxbx = field_168_fcPlcffldTxbx;
        }

        /**
         * Get the lcbPlcffldTxbx field for the FIB record.
         */
        public int GetLcbPlcffldTxbx()
        {
            return field_169_lcbPlcffldTxbx;
        }

        /**
         * Set the lcbPlcffldTxbx field for the FIB record.
         */
        public void SetLcbPlcffldTxbx(int field_169_lcbPlcffldTxbx)
        {
            this.field_169_lcbPlcffldTxbx = field_169_lcbPlcffldTxbx;
        }

        /**
         * Get the fcPlcfhdrtxbxTxt field for the FIB record.
         */
        public int GetFcPlcfhdrtxbxTxt()
        {
            return field_170_fcPlcfhdrtxbxTxt;
        }

        /**
         * Set the fcPlcfhdrtxbxTxt field for the FIB record.
         */
        public void SetFcPlcfhdrtxbxTxt(int field_170_fcPlcfhdrtxbxTxt)
        {
            this.field_170_fcPlcfhdrtxbxTxt = field_170_fcPlcfhdrtxbxTxt;
        }

        /**
         * Get the lcbPlcfhdrtxbxTxt field for the FIB record.
         */
        public int GetLcbPlcfhdrtxbxTxt()
        {
            return field_171_lcbPlcfhdrtxbxTxt;
        }

        /**
         * Set the lcbPlcfhdrtxbxTxt field for the FIB record.
         */
        public void SetLcbPlcfhdrtxbxTxt(int field_171_lcbPlcfhdrtxbxTxt)
        {
            this.field_171_lcbPlcfhdrtxbxTxt = field_171_lcbPlcfhdrtxbxTxt;
        }

        /**
         * Get the fcPlcffldHdrTxbx field for the FIB record.
         */
        public int GetFcPlcffldHdrTxbx()
        {
            return field_172_fcPlcffldHdrTxbx;
        }

        /**
         * Set the fcPlcffldHdrTxbx field for the FIB record.
         */
        public void SetFcPlcffldHdrTxbx(int field_172_fcPlcffldHdrTxbx)
        {
            this.field_172_fcPlcffldHdrTxbx = field_172_fcPlcffldHdrTxbx;
        }

        /**
         * Get the lcbPlcffldHdrTxbx field for the FIB record.
         */
        public int GetLcbPlcffldHdrTxbx()
        {
            return field_173_lcbPlcffldHdrTxbx;
        }

        /**
         * Set the lcbPlcffldHdrTxbx field for the FIB record.
         */
        public void SetLcbPlcffldHdrTxbx(int field_173_lcbPlcffldHdrTxbx)
        {
            this.field_173_lcbPlcffldHdrTxbx = field_173_lcbPlcffldHdrTxbx;
        }

        /**
         * Get the fcStwUser field for the FIB record.
         */
        public int GetFcStwUser()
        {
            return field_174_fcStwUser;
        }

        /**
         * Set the fcStwUser field for the FIB record.
         */
        public void SetFcStwUser(int field_174_fcStwUser)
        {
            this.field_174_fcStwUser = field_174_fcStwUser;
        }

        /**
         * Get the lcbStwUser field for the FIB record.
         */
        public int GetLcbStwUser()
        {
            return field_175_lcbStwUser;
        }

        /**
         * Set the lcbStwUser field for the FIB record.
         */
        public void SetLcbStwUser(int field_175_lcbStwUser)
        {
            this.field_175_lcbStwUser = field_175_lcbStwUser;
        }

        /**
         * Get the fcSttbttmbd field for the FIB record.
         */
        public int GetFcSttbttmbd()
        {
            return field_176_fcSttbttmbd;
        }

        /**
         * Set the fcSttbttmbd field for the FIB record.
         */
        public void SetFcSttbttmbd(int field_176_fcSttbttmbd)
        {
            this.field_176_fcSttbttmbd = field_176_fcSttbttmbd;
        }

        /**
         * Get the cbSttbttmbd field for the FIB record.
         */
        public int GetCbSttbttmbd()
        {
            return field_177_cbSttbttmbd;
        }

        /**
         * Set the cbSttbttmbd field for the FIB record.
         */
        public void SetCbSttbttmbd(int field_177_cbSttbttmbd)
        {
            this.field_177_cbSttbttmbd = field_177_cbSttbttmbd;
        }

        /**
         * Get the fcUnused field for the FIB record.
         */
        public int GetFcUnused()
        {
            return field_178_fcUnused;
        }

        /**
         * Set the fcUnused field for the FIB record.
         */
        public void SetFcUnused(int field_178_fcUnused)
        {
            this.field_178_fcUnused = field_178_fcUnused;
        }

        /**
         * Get the lcbUnused field for the FIB record.
         */
        public int GetLcbUnused()
        {
            return field_179_lcbUnused;
        }

        /**
         * Set the lcbUnused field for the FIB record.
         */
        public void SetLcbUnused(int field_179_lcbUnused)
        {
            this.field_179_lcbUnused = field_179_lcbUnused;
        }

        /**
         * Get the fcPgdMother field for the FIB record.
         */
        public int GetFcPgdMother()
        {
            return field_180_fcPgdMother;
        }

        /**
         * Set the fcPgdMother field for the FIB record.
         */
        public void SetFcPgdMother(int field_180_fcPgdMother)
        {
            this.field_180_fcPgdMother = field_180_fcPgdMother;
        }

        /**
         * Get the lcbPgdMother field for the FIB record.
         */
        public int GetLcbPgdMother()
        {
            return field_181_lcbPgdMother;
        }

        /**
         * Set the lcbPgdMother field for the FIB record.
         */
        public void SetLcbPgdMother(int field_181_lcbPgdMother)
        {
            this.field_181_lcbPgdMother = field_181_lcbPgdMother;
        }

        /**
         * Get the fcBkdMother field for the FIB record.
         */
        public int GetFcBkdMother()
        {
            return field_182_fcBkdMother;
        }

        /**
         * Set the fcBkdMother field for the FIB record.
         */
        public void SetFcBkdMother(int field_182_fcBkdMother)
        {
            this.field_182_fcBkdMother = field_182_fcBkdMother;
        }

        /**
         * Get the lcbBkdMother field for the FIB record.
         */
        public int GetLcbBkdMother()
        {
            return field_183_lcbBkdMother;
        }

        /**
         * Set the lcbBkdMother field for the FIB record.
         */
        public void SetLcbBkdMother(int field_183_lcbBkdMother)
        {
            this.field_183_lcbBkdMother = field_183_lcbBkdMother;
        }

        /**
         * Get the fcPgdFtn field for the FIB record.
         */
        public int GetFcPgdFtn()
        {
            return field_184_fcPgdFtn;
        }

        /**
         * Set the fcPgdFtn field for the FIB record.
         */
        public void SetFcPgdFtn(int field_184_fcPgdFtn)
        {
            this.field_184_fcPgdFtn = field_184_fcPgdFtn;
        }

        /**
         * Get the lcbPgdFtn field for the FIB record.
         */
        public int GetLcbPgdFtn()
        {
            return field_185_lcbPgdFtn;
        }

        /**
         * Set the lcbPgdFtn field for the FIB record.
         */
        public void SetLcbPgdFtn(int field_185_lcbPgdFtn)
        {
            this.field_185_lcbPgdFtn = field_185_lcbPgdFtn;
        }

        /**
         * Get the fcBkdFtn field for the FIB record.
         */
        public int GetFcBkdFtn()
        {
            return field_186_fcBkdFtn;
        }

        /**
         * Set the fcBkdFtn field for the FIB record.
         */
        public void SetFcBkdFtn(int field_186_fcBkdFtn)
        {
            this.field_186_fcBkdFtn = field_186_fcBkdFtn;
        }

        /**
         * Get the lcbBkdFtn field for the FIB record.
         */
        public int GetLcbBkdFtn()
        {
            return field_187_lcbBkdFtn;
        }

        /**
         * Set the lcbBkdFtn field for the FIB record.
         */
        public void SetLcbBkdFtn(int field_187_lcbBkdFtn)
        {
            this.field_187_lcbBkdFtn = field_187_lcbBkdFtn;
        }

        /**
         * Get the fcPgdEdn field for the FIB record.
         */
        public int GetFcPgdEdn()
        {
            return field_188_fcPgdEdn;
        }

        /**
         * Set the fcPgdEdn field for the FIB record.
         */
        public void SetFcPgdEdn(int field_188_fcPgdEdn)
        {
            this.field_188_fcPgdEdn = field_188_fcPgdEdn;
        }

        /**
         * Get the lcbPgdEdn field for the FIB record.
         */
        public int GetLcbPgdEdn()
        {
            return field_189_lcbPgdEdn;
        }

        /**
         * Set the lcbPgdEdn field for the FIB record.
         */
        public void SetLcbPgdEdn(int field_189_lcbPgdEdn)
        {
            this.field_189_lcbPgdEdn = field_189_lcbPgdEdn;
        }

        /**
         * Get the fcBkdEdn field for the FIB record.
         */
        public int GetFcBkdEdn()
        {
            return field_190_fcBkdEdn;
        }

        /**
         * Set the fcBkdEdn field for the FIB record.
         */
        public void SetFcBkdEdn(int field_190_fcBkdEdn)
        {
            this.field_190_fcBkdEdn = field_190_fcBkdEdn;
        }

        /**
         * Get the lcbBkdEdn field for the FIB record.
         */
        public int GetLcbBkdEdn()
        {
            return field_191_lcbBkdEdn;
        }

        /**
         * Set the lcbBkdEdn field for the FIB record.
         */
        public void SetLcbBkdEdn(int field_191_lcbBkdEdn)
        {
            this.field_191_lcbBkdEdn = field_191_lcbBkdEdn;
        }

        /**
         * Get the fcSttbfIntlFld field for the FIB record.
         */
        public int GetFcSttbfIntlFld()
        {
            return field_192_fcSttbfIntlFld;
        }

        /**
         * Set the fcSttbfIntlFld field for the FIB record.
         */
        public void SetFcSttbfIntlFld(int field_192_fcSttbfIntlFld)
        {
            this.field_192_fcSttbfIntlFld = field_192_fcSttbfIntlFld;
        }

        /**
         * Get the lcbSttbfIntlFld field for the FIB record.
         */
        public int GetLcbSttbfIntlFld()
        {
            return field_193_lcbSttbfIntlFld;
        }

        /**
         * Set the lcbSttbfIntlFld field for the FIB record.
         */
        public void SetLcbSttbfIntlFld(int field_193_lcbSttbfIntlFld)
        {
            this.field_193_lcbSttbfIntlFld = field_193_lcbSttbfIntlFld;
        }

        /**
         * Get the fcRouteSlip field for the FIB record.
         */
        public int GetFcRouteSlip()
        {
            return field_194_fcRouteSlip;
        }

        /**
         * Set the fcRouteSlip field for the FIB record.
         */
        public void SetFcRouteSlip(int field_194_fcRouteSlip)
        {
            this.field_194_fcRouteSlip = field_194_fcRouteSlip;
        }

        /**
         * Get the lcbRouteSlip field for the FIB record.
         */
        public int GetLcbRouteSlip()
        {
            return field_195_lcbRouteSlip;
        }

        /**
         * Set the lcbRouteSlip field for the FIB record.
         */
        public void SetLcbRouteSlip(int field_195_lcbRouteSlip)
        {
            this.field_195_lcbRouteSlip = field_195_lcbRouteSlip;
        }

        /**
         * Get the fcSttbSavedBy field for the FIB record.
         */
        public int GetFcSttbSavedBy()
        {
            return field_196_fcSttbSavedBy;
        }

        /**
         * Set the fcSttbSavedBy field for the FIB record.
         */
        public void SetFcSttbSavedBy(int field_196_fcSttbSavedBy)
        {
            this.field_196_fcSttbSavedBy = field_196_fcSttbSavedBy;
        }

        /**
         * Get the lcbSttbSavedBy field for the FIB record.
         */
        public int GetLcbSttbSavedBy()
        {
            return field_197_lcbSttbSavedBy;
        }

        /**
         * Set the lcbSttbSavedBy field for the FIB record.
         */
        public void SetLcbSttbSavedBy(int field_197_lcbSttbSavedBy)
        {
            this.field_197_lcbSttbSavedBy = field_197_lcbSttbSavedBy;
        }

        /**
         * Get the fcSttbFnm field for the FIB record.
         */
        public int GetFcSttbFnm()
        {
            return field_198_fcSttbFnm;
        }

        /**
         * Set the fcSttbFnm field for the FIB record.
         */
        public void SetFcSttbFnm(int field_198_fcSttbFnm)
        {
            this.field_198_fcSttbFnm = field_198_fcSttbFnm;
        }

        /**
         * Get the lcbSttbFnm field for the FIB record.
         */
        public int GetLcbSttbFnm()
        {
            return field_199_lcbSttbFnm;
        }

        /**
         * Set the lcbSttbFnm field for the FIB record.
         */
        public void SetLcbSttbFnm(int field_199_lcbSttbFnm)
        {
            this.field_199_lcbSttbFnm = field_199_lcbSttbFnm;
        }

        /**
         * Get the fcPlcfLst field for the FIB record.
         */
        public int GetFcPlcfLst()
        {
            return field_200_fcPlcfLst;
        }

        /**
         * Set the fcPlcfLst field for the FIB record.
         */
        public void SetFcPlcfLst(int field_200_fcPlcfLst)
        {
            this.field_200_fcPlcfLst = field_200_fcPlcfLst;
        }

        /**
         * Get the lcbPlcfLst field for the FIB record.
         */
        public int GetLcbPlcfLst()
        {
            return field_201_lcbPlcfLst;
        }

        /**
         * Set the lcbPlcfLst field for the FIB record.
         */
        public void SetLcbPlcfLst(int field_201_lcbPlcfLst)
        {
            this.field_201_lcbPlcfLst = field_201_lcbPlcfLst;
        }

        /**
         * Get the fcPlfLfo field for the FIB record.
         */
        public int GetFcPlfLfo()
        {
            return field_202_fcPlfLfo;
        }

        /**
         * Set the fcPlfLfo field for the FIB record.
         */
        public void SetFcPlfLfo(int field_202_fcPlfLfo)
        {
            this.field_202_fcPlfLfo = field_202_fcPlfLfo;
        }

        /**
         * Get the lcbPlfLfo field for the FIB record.
         */
        public int GetLcbPlfLfo()
        {
            return field_203_lcbPlfLfo;
        }

        /**
         * Set the lcbPlfLfo field for the FIB record.
         */
        public void SetLcbPlfLfo(int field_203_lcbPlfLfo)
        {
            this.field_203_lcbPlfLfo = field_203_lcbPlfLfo;
        }

        /**
         * Get the fcPlcftxbxBkd field for the FIB record.
         */
        public int GetFcPlcftxbxBkd()
        {
            return field_204_fcPlcftxbxBkd;
        }

        /**
         * Set the fcPlcftxbxBkd field for the FIB record.
         */
        public void SetFcPlcftxbxBkd(int field_204_fcPlcftxbxBkd)
        {
            this.field_204_fcPlcftxbxBkd = field_204_fcPlcftxbxBkd;
        }

        /**
         * Get the lcbPlcftxbxBkd field for the FIB record.
         */
        public int GetLcbPlcftxbxBkd()
        {
            return field_205_lcbPlcftxbxBkd;
        }

        /**
         * Set the lcbPlcftxbxBkd field for the FIB record.
         */
        public void SetLcbPlcftxbxBkd(int field_205_lcbPlcftxbxBkd)
        {
            this.field_205_lcbPlcftxbxBkd = field_205_lcbPlcftxbxBkd;
        }

        /**
         * Get the fcPlcftxbxHdrBkd field for the FIB record.
         */
        public int GetFcPlcftxbxHdrBkd()
        {
            return field_206_fcPlcftxbxHdrBkd;
        }

        /**
         * Set the fcPlcftxbxHdrBkd field for the FIB record.
         */
        public void SetFcPlcftxbxHdrBkd(int field_206_fcPlcftxbxHdrBkd)
        {
            this.field_206_fcPlcftxbxHdrBkd = field_206_fcPlcftxbxHdrBkd;
        }

        /**
         * Get the lcbPlcftxbxHdrBkd field for the FIB record.
         */
        public int GetLcbPlcftxbxHdrBkd()
        {
            return field_207_lcbPlcftxbxHdrBkd;
        }

        /**
         * Set the lcbPlcftxbxHdrBkd field for the FIB record.
         */
        public void SetLcbPlcftxbxHdrBkd(int field_207_lcbPlcftxbxHdrBkd)
        {
            this.field_207_lcbPlcftxbxHdrBkd = field_207_lcbPlcftxbxHdrBkd;
        }

        /**
         * Get the fcDocUndo field for the FIB record.
         */
        public int GetFcDocUndo()
        {
            return field_208_fcDocUndo;
        }

        /**
         * Set the fcDocUndo field for the FIB record.
         */
        public void SetFcDocUndo(int field_208_fcDocUndo)
        {
            this.field_208_fcDocUndo = field_208_fcDocUndo;
        }

        /**
         * Get the lcbDocUndo field for the FIB record.
         */
        public int GetLcbDocUndo()
        {
            return field_209_lcbDocUndo;
        }

        /**
         * Set the lcbDocUndo field for the FIB record.
         */
        public void SetLcbDocUndo(int field_209_lcbDocUndo)
        {
            this.field_209_lcbDocUndo = field_209_lcbDocUndo;
        }

        /**
         * Get the fcRgbuse field for the FIB record.
         */
        public int GetFcRgbuse()
        {
            return field_210_fcRgbuse;
        }

        /**
         * Set the fcRgbuse field for the FIB record.
         */
        public void SetFcRgbuse(int field_210_fcRgbuse)
        {
            this.field_210_fcRgbuse = field_210_fcRgbuse;
        }

        /**
         * Get the lcbRgbuse field for the FIB record.
         */
        public int GetLcbRgbuse()
        {
            return field_211_lcbRgbuse;
        }

        /**
         * Set the lcbRgbuse field for the FIB record.
         */
        public void SetLcbRgbuse(int field_211_lcbRgbuse)
        {
            this.field_211_lcbRgbuse = field_211_lcbRgbuse;
        }

        /**
         * Get the fcUsp field for the FIB record.
         */
        public int GetFcUsp()
        {
            return field_212_fcUsp;
        }

        /**
         * Set the fcUsp field for the FIB record.
         */
        public void SetFcUsp(int field_212_fcUsp)
        {
            this.field_212_fcUsp = field_212_fcUsp;
        }

        /**
         * Get the lcbUsp field for the FIB record.
         */
        public int GetLcbUsp()
        {
            return field_213_lcbUsp;
        }

        /**
         * Set the lcbUsp field for the FIB record.
         */
        public void SetLcbUsp(int field_213_lcbUsp)
        {
            this.field_213_lcbUsp = field_213_lcbUsp;
        }

        /**
         * Get the fcUskf field for the FIB record.
         */
        public int GetFcUskf()
        {
            return field_214_fcUskf;
        }

        /**
         * Set the fcUskf field for the FIB record.
         */
        public void SetFcUskf(int field_214_fcUskf)
        {
            this.field_214_fcUskf = field_214_fcUskf;
        }

        /**
         * Get the lcbUskf field for the FIB record.
         */
        public int GetLcbUskf()
        {
            return field_215_lcbUskf;
        }

        /**
         * Set the lcbUskf field for the FIB record.
         */
        public void SetLcbUskf(int field_215_lcbUskf)
        {
            this.field_215_lcbUskf = field_215_lcbUskf;
        }

        /**
         * Get the fcPlcupcRgbuse field for the FIB record.
         */
        public int GetFcPlcupcRgbuse()
        {
            return field_216_fcPlcupcRgbuse;
        }

        /**
         * Set the fcPlcupcRgbuse field for the FIB record.
         */
        public void SetFcPlcupcRgbuse(int field_216_fcPlcupcRgbuse)
        {
            this.field_216_fcPlcupcRgbuse = field_216_fcPlcupcRgbuse;
        }

        /**
         * Get the lcbPlcupcRgbuse field for the FIB record.
         */
        public int GetLcbPlcupcRgbuse()
        {
            return field_217_lcbPlcupcRgbuse;
        }

        /**
         * Set the lcbPlcupcRgbuse field for the FIB record.
         */
        public void SetLcbPlcupcRgbuse(int field_217_lcbPlcupcRgbuse)
        {
            this.field_217_lcbPlcupcRgbuse = field_217_lcbPlcupcRgbuse;
        }

        /**
         * Get the fcPlcupcUsp field for the FIB record.
         */
        public int GetFcPlcupcUsp()
        {
            return field_218_fcPlcupcUsp;
        }

        /**
         * Set the fcPlcupcUsp field for the FIB record.
         */
        public void SetFcPlcupcUsp(int field_218_fcPlcupcUsp)
        {
            this.field_218_fcPlcupcUsp = field_218_fcPlcupcUsp;
        }

        /**
         * Get the lcbPlcupcUsp field for the FIB record.
         */
        public int GetLcbPlcupcUsp()
        {
            return field_219_lcbPlcupcUsp;
        }

        /**
         * Set the lcbPlcupcUsp field for the FIB record.
         */
        public void SetLcbPlcupcUsp(int field_219_lcbPlcupcUsp)
        {
            this.field_219_lcbPlcupcUsp = field_219_lcbPlcupcUsp;
        }

        /**
         * Get the fcSttbGlsyStyle field for the FIB record.
         */
        public int GetFcSttbGlsyStyle()
        {
            return field_220_fcSttbGlsyStyle;
        }

        /**
         * Set the fcSttbGlsyStyle field for the FIB record.
         */
        public void SetFcSttbGlsyStyle(int field_220_fcSttbGlsyStyle)
        {
            this.field_220_fcSttbGlsyStyle = field_220_fcSttbGlsyStyle;
        }

        /**
         * Get the lcbSttbGlsyStyle field for the FIB record.
         */
        public int GetLcbSttbGlsyStyle()
        {
            return field_221_lcbSttbGlsyStyle;
        }

        /**
         * Set the lcbSttbGlsyStyle field for the FIB record.
         */
        public void SetLcbSttbGlsyStyle(int field_221_lcbSttbGlsyStyle)
        {
            this.field_221_lcbSttbGlsyStyle = field_221_lcbSttbGlsyStyle;
        }

        /**
         * Get the fcPlgosl field for the FIB record.
         */
        public int GetFcPlgosl()
        {
            return field_222_fcPlgosl;
        }

        /**
         * Set the fcPlgosl field for the FIB record.
         */
        public void SetFcPlgosl(int field_222_fcPlgosl)
        {
            this.field_222_fcPlgosl = field_222_fcPlgosl;
        }

        /**
         * Get the lcbPlgosl field for the FIB record.
         */
        public int GetLcbPlgosl()
        {
            return field_223_lcbPlgosl;
        }

        /**
         * Set the lcbPlgosl field for the FIB record.
         */
        public void SetLcbPlgosl(int field_223_lcbPlgosl)
        {
            this.field_223_lcbPlgosl = field_223_lcbPlgosl;
        }

        /**
         * Get the fcPlcocx field for the FIB record.
         */
        public int GetFcPlcocx()
        {
            return field_224_fcPlcocx;
        }

        /**
         * Set the fcPlcocx field for the FIB record.
         */
        public void SetFcPlcocx(int field_224_fcPlcocx)
        {
            this.field_224_fcPlcocx = field_224_fcPlcocx;
        }

        /**
         * Get the lcbPlcocx field for the FIB record.
         */
        public int GetLcbPlcocx()
        {
            return field_225_lcbPlcocx;
        }

        /**
         * Set the lcbPlcocx field for the FIB record.
         */
        public void SetLcbPlcocx(int field_225_lcbPlcocx)
        {
            this.field_225_lcbPlcocx = field_225_lcbPlcocx;
        }

        /**
         * Get the fcPlcfbteLvc field for the FIB record.
         */
        public int GetFcPlcfbteLvc()
        {
            return field_226_fcPlcfbteLvc;
        }

        /**
         * Set the fcPlcfbteLvc field for the FIB record.
         */
        public void SetFcPlcfbteLvc(int field_226_fcPlcfbteLvc)
        {
            this.field_226_fcPlcfbteLvc = field_226_fcPlcfbteLvc;
        }

        /**
         * Get the lcbPlcfbteLvc field for the FIB record.
         */
        public int GetLcbPlcfbteLvc()
        {
            return field_227_lcbPlcfbteLvc;
        }

        /**
         * Set the lcbPlcfbteLvc field for the FIB record.
         */
        public void SetLcbPlcfbteLvc(int field_227_lcbPlcfbteLvc)
        {
            this.field_227_lcbPlcfbteLvc = field_227_lcbPlcfbteLvc;
        }

        /**
         * Get the dwLowDateTime field for the FIB record.
         */
        public int GetDwLowDateTime()
        {
            return field_228_dwLowDateTime;
        }

        /**
         * Set the dwLowDateTime field for the FIB record.
         */
        public void SetDwLowDateTime(int field_228_dwLowDateTime)
        {
            this.field_228_dwLowDateTime = field_228_dwLowDateTime;
        }

        /**
         * Get the dwHighDateTime field for the FIB record.
         */
        public int GetDwHighDateTime()
        {
            return field_229_dwHighDateTime;
        }

        /**
         * Set the dwHighDateTime field for the FIB record.
         */
        public void SetDwHighDateTime(int field_229_dwHighDateTime)
        {
            this.field_229_dwHighDateTime = field_229_dwHighDateTime;
        }

        /**
         * Get the fcPlcflvc field for the FIB record.
         */
        public int GetFcPlcflvc()
        {
            return field_230_fcPlcflvc;
        }

        /**
         * Set the fcPlcflvc field for the FIB record.
         */
        public void SetFcPlcflvc(int field_230_fcPlcflvc)
        {
            this.field_230_fcPlcflvc = field_230_fcPlcflvc;
        }

        /**
         * Get the lcbPlcflvc field for the FIB record.
         */
        public int GetLcbPlcflvc()
        {
            return field_231_lcbPlcflvc;
        }

        /**
         * Set the lcbPlcflvc field for the FIB record.
         */
        public void SetLcbPlcflvc(int field_231_lcbPlcflvc)
        {
            this.field_231_lcbPlcflvc = field_231_lcbPlcflvc;
        }

        /**
         * Get the fcPlcasumy field for the FIB record.
         */
        public int GetFcPlcasumy()
        {
            return field_232_fcPlcasumy;
        }

        /**
         * Set the fcPlcasumy field for the FIB record.
         */
        public void SetFcPlcasumy(int field_232_fcPlcasumy)
        {
            this.field_232_fcPlcasumy = field_232_fcPlcasumy;
        }

        /**
         * Get the lcbPlcasumy field for the FIB record.
         */
        public int GetLcbPlcasumy()
        {
            return field_233_lcbPlcasumy;
        }

        /**
         * Set the lcbPlcasumy field for the FIB record.
         */
        public void SetLcbPlcasumy(int field_233_lcbPlcasumy)
        {
            this.field_233_lcbPlcasumy = field_233_lcbPlcasumy;
        }

        /**
         * Get the fcPlcfgram field for the FIB record.
         */
        public int GetFcPlcfgram()
        {
            return field_234_fcPlcfgram;
        }

        /**
         * Set the fcPlcfgram field for the FIB record.
         */
        public void SetFcPlcfgram(int field_234_fcPlcfgram)
        {
            this.field_234_fcPlcfgram = field_234_fcPlcfgram;
        }

        /**
         * Get the lcbPlcfgram field for the FIB record.
         */
        public int GetLcbPlcfgram()
        {
            return field_235_lcbPlcfgram;
        }

        /**
         * Set the lcbPlcfgram field for the FIB record.
         */
        public void SetLcbPlcfgram(int field_235_lcbPlcfgram)
        {
            this.field_235_lcbPlcfgram = field_235_lcbPlcfgram;
        }

        /**
         * Get the fcSttbListNames field for the FIB record.
         */
        public int GetFcSttbListNames()
        {
            return field_236_fcSttbListNames;
        }

        /**
         * Set the fcSttbListNames field for the FIB record.
         */
        public void SetFcSttbListNames(int field_236_fcSttbListNames)
        {
            this.field_236_fcSttbListNames = field_236_fcSttbListNames;
        }

        /**
         * Get the lcbSttbListNames field for the FIB record.
         */
        public int GetLcbSttbListNames()
        {
            return field_237_lcbSttbListNames;
        }

        /**
         * Set the lcbSttbListNames field for the FIB record.
         */
        public void SetLcbSttbListNames(int field_237_lcbSttbListNames)
        {
            this.field_237_lcbSttbListNames = field_237_lcbSttbListNames;
        }

        /**
         * Get the fcSttbfUssr field for the FIB record.
         */
        public int GetFcSttbfUssr()
        {
            return field_238_fcSttbfUssr;
        }

        /**
         * Set the fcSttbfUssr field for the FIB record.
         */
        public void SetFcSttbfUssr(int field_238_fcSttbfUssr)
        {
            this.field_238_fcSttbfUssr = field_238_fcSttbfUssr;
        }

        /**
         * Get the lcbSttbfUssr field for the FIB record.
         */
        public int GetLcbSttbfUssr()
        {
            return field_239_lcbSttbfUssr;
        }

        /**
         * Set the lcbSttbfUssr field for the FIB record.
         */
        public void SetLcbSttbfUssr(int field_239_lcbSttbfUssr)
        {
            this.field_239_lcbSttbfUssr = field_239_lcbSttbfUssr;
        }

        /**
         * Sets the fDot field value.
         *
         */
        public void SetFDot(bool value)
        {
            field_6_options = (short)fDot.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fDot field value.
         */
        public bool IsFDot()
        {
            return fDot.IsSet(field_6_options);

        }

        /**
         * Sets the fGlsy field value.
         *
         */
        public void SetFGlsy(bool value)
        {
            field_6_options = (short)fGlsy.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fGlsy field value.
         */
        public bool IsFGlsy()
        {
            return fGlsy.IsSet(field_6_options);

        }

        /**
         * Sets the fComplex field value.
         *
         */
        public void SetFComplex(bool value)
        {
            field_6_options = (short)fComplex.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fComplex field value.
         */
        public bool IsFComplex()
        {
            return fComplex.IsSet(field_6_options);

        }

        /**
         * Sets the fHasPic field value.
         *
         */
        public void SetFHasPic(bool value)
        {
            field_6_options = (short)fHasPic.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fHasPic field value.
         */
        public bool IsFHasPic()
        {
            return fHasPic.IsSet(field_6_options);

        }

        /**
         * Sets the cQuickSaves field value.
         *
         */
        public void SetCQuickSaves(byte value)
        {
            field_6_options = (short)cQuickSaves.SetValue(field_6_options, value);


        }

        /**
         *
         * @return  the cQuickSaves field value.
         */
        public byte GetCQuickSaves()
        {
            return (byte)cQuickSaves.GetValue(field_6_options);

        }

        /**
         * Sets the fEncrypted field value.
         *
         */
        public void SetFEncrypted(bool value)
        {
            field_6_options = (short)fEncrypted.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fEncrypted field value.
         */
        public bool IsFEncrypted()
        {
            return fEncrypted.IsSet(field_6_options);

        }

        /**
         * Sets the fWhichTblStm field value.
         *
         */
        public void SetFWhichTblStm(bool value)
        {
            field_6_options = (short)fWhichTblStm.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fWhichTblStm field value.
         */
        public bool IsFWhichTblStm()
        {
            return fWhichTblStm.IsSet(field_6_options);

        }

        /**
         * Sets the fReadOnlyRecommended field value.
         *
         */
        public void SetFReadOnlyRecommended(bool value)
        {
            field_6_options = (short)fReadOnlyRecommended.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fReadOnlyRecommended field value.
         */
        public bool IsFReadOnlyRecommended()
        {
            return fReadOnlyRecommended.IsSet(field_6_options);

        }

        /**
         * Sets the fWriteReservation field value.
         *
         */
        public void SetFWriteReservation(bool value)
        {
            field_6_options = (short)fWriteReservation.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fWriteReservation field value.
         */
        public bool IsFWriteReservation()
        {
            return fWriteReservation.IsSet(field_6_options);

        }

        /**
         * Sets the fExtChar field value.
         *
         */
        public void SetFExtChar(bool value)
        {
            field_6_options = (short)fExtChar.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fExtChar field value.
         */
        public bool IsFExtChar()
        {
            return fExtChar.IsSet(field_6_options);

        }

        /**
         * Sets the fLoadOverride field value.
         *
         */
        public void SetFLoadOverride(bool value)
        {
            field_6_options = (short)fLoadOverride.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fLoadOverride field value.
         */
        public bool IsFLoadOverride()
        {
            return fLoadOverride.IsSet(field_6_options);

        }

        /**
         * Sets the fFarEast field value.
         *
         */
        public void SetFFarEast(bool value)
        {
            field_6_options = (short)fFarEast.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fFarEast field value.
         */
        public bool IsFFarEast()
        {
            return fFarEast.IsSet(field_6_options);

        }

        /**
         * Sets the fCrypto field value.
         *
         */
        public void SetFCrypto(bool value)
        {
            field_6_options = (short)fCrypto.SetBoolean(field_6_options, value);


        }

        /**
         *
         * @return  the fCrypto field value.
         */
        public bool IsFCrypto()
        {
            return fCrypto.IsSet(field_6_options);

        }

        /**
         * Sets the fMac field value.
         *
         */
        public void SetFMac(bool value)
        {
            field_10_history = (short)fMac.SetBoolean(field_10_history, value);


        }

        /**
         *
         * @return  the fMac field value.
         */
        public bool IsFMac()
        {
            return fMac.IsSet(field_10_history);

        }

        /**
         * Sets the fEmptySpecial field value.
         *
         */
        public void SetFEmptySpecial(bool value)
        {
            field_10_history = (short)fEmptySpecial.SetBoolean(field_10_history, value);


        }

        /**
         *
         * @return  the fEmptySpecial field value.
         */
        public bool IsFEmptySpecial()
        {
            return fEmptySpecial.IsSet(field_10_history);

        }

        /**
         * Sets the fLoadOverridePage field value.
         *
         */
        public void SetFLoadOverridePage(bool value)
        {
            field_10_history = (short)fLoadOverridePage.SetBoolean(field_10_history, value);


        }

        /**
         *
         * @return  the fLoadOverridePage field value.
         */
        public bool IsFLoadOverridePage()
        {
            return fLoadOverridePage.IsSet(field_10_history);

        }

        /**
         * Sets the fFutureSavedUndo field value.
         *
         */
        public void SetFFutureSavedUndo(bool value)
        {
            field_10_history = (short)fFutureSavedUndo.SetBoolean(field_10_history, value);


        }

        /**
         *
         * @return  the fFutureSavedUndo field value.
         */
        public bool IsFFutureSavedUndo()
        {
            return fFutureSavedUndo.IsSet(field_10_history);

        }

        /**
         * Sets the fWord97Saved field value.
         *
         */
        public void SetFWord97Saved(bool value)
        {
            field_10_history = (short)fWord97Saved.SetBoolean(field_10_history, value);


        }

        /**
         *
         * @return  the fWord97Saved field value.
         */
        public bool IsFWord97Saved()
        {
            return fWord97Saved.IsSet(field_10_history);

        }

        /**
         * Sets the fSpare0 field value.
         *
         */
        public void SetFSpare0(byte value)
        {
            field_10_history = (short)fSpare0.SetValue(field_10_history, value);


        }

        /**
         *
         * @return  the fSpare0 field value.
         */
        public byte GetFSpare0()
        {
            return (byte)fSpare0.GetValue(field_10_history);

        }


    }
}