﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" AutoEventWireup="true" CodeBehind="Editor.aspx.cs" Inherits="SVN.Net.Views.Editor.Editor" %>
<asp:Content ID="editorContent" ContentPlaceHolderID="MainContent" runat="server">
<% var action = (bool)ViewData["isnew"] ? "\"/Editor/CreateFile\"" : "\"/Editor/Edit\""; %>
<form action=<%= action %> method="post">
    <table width="100%">
        <tr>
            <td colspan="2">
                <%= Html.ValidationSummary() %>
            </td>
        </tr>
        <tr>
            <td width="10%"><b>Repo Information:</b></td>
            <td><%= Html.TextBox("repo", (string)ViewData["repo"] ?? string.Empty, new { @readonly = "readonly" })%></td>
        </tr>
        <tr>
            <td width="10%"><b>File Name:</b></td>
            <td>
                <%if ((bool)ViewData["isnew"])
                  { %>
                    <%= Html.TextBox("name", (string)ViewData["name"] ?? string.Empty)%>
                <%}
                  else
                  { %>
                    <%= Html.TextBox("name", (string)ViewData["name"] ?? string.Empty, new { @readonly = "readonly" })%>
                <%} %>
                <%= Html.ValidationMessage("name", "*") %>
            </td>
        </tr>
        <tr valign="top">
            <td width="10%"><b>Context:</b></td>
            <td><%= Html.TextArea("code", ViewData.Model ?? string.Empty) %></td>
        </tr>
        <tr valign="top">
            <td width="10%"><b>Message:</b></td>
            <td>
                <%= Html.TextArea("message", (string)ViewData["message"] ?? string.Empty)%><br />
                <i>Optional. If not SVN.Net will utilize the common meesage here.</i>
            </td>
        </tr>
    </table>
    <table width="100%">
        <tr>
            <td width="10%">
                <% if (string.IsNullOrEmpty(ViewData["name"].ToString()))
                   { %>
                    <%= Html.SubmitButton("CreateFile", "Save")%>
                <% }
                   else
                   { %>
                    <%= Html.SubmitButton("CommitSingleFile", "Save")%>
                <% } %>
            </td>
            <td width="10%"><%= Html.ActionLink("Cancel", "Cancel", "Editor", new { repo = (string)ViewData["repo"] }, null) %></td>
            <td></td>
        </tr>
    </table>
</form>
</asp:Content>
